/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclASTUtil;
import org.eclipse.dltk.tcl.internal.parser.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclParseUtil {
    public static String extractWord(TclElement element, String content) {
        return content.substring(element.getStart(), element.getEnd() + 1);
    }

    public static boolean isCommandStart(Object object) {
        return object != null && object.getClass().equals(TclWord.class);
    }

    public static String extractBraces(String s) {
        int len;
        if (s != null && (len = s.length()) >= 2 && s.charAt(0) == '{' && s.charAt(len - 1) == '}') {
            return s.substring(1, len - 1);
        }
        return s;
    }

    public static String nameFromBlock(String name, char c1, char c2) {
        int pos = name.indexOf(c1);
        String nname = name.substring(pos + 1);
        pos = nname.lastIndexOf(c2);
        if (nname.length() > pos) {
            nname = nname.substring(0, pos);
        }
        return nname;
    }

    public static boolean isArrayVariable(String name) {
        if (name.length() <= 2) {
            return false;
        }
        if (!name.endsWith(")")) {
            return false;
        }
        return name.indexOf(40) != -1;
    }

    public static String escapeName(String name) {
        name = SimpleTclParser.magicSubstitute((String)name);
        StringBuilder res = null;
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch = name.charAt(i);
            if (Character.isISOControl(ch)) {
                if (res == null) {
                    res = new StringBuilder(name.length() * 2);
                    res.append(name, 0, i);
                }
                res.append("\\u");
                String tmp = Integer.toHexString(ch).toUpperCase();
                if (tmp.length() == 1) {
                    res.append("0");
                }
                res.append(tmp);
            } else if (res != null) {
                res.append(ch);
            }
            ++i;
        }
        if (res != null) {
            if (res.length() == 0 || res.charAt(0) == ' ' || res.charAt(res.length() - 1) == ' ') {
                res.insert(0, '{');
                res.append('}');
            }
            return res.toString();
        }
        if (name.length() == 0 || name.charAt(0) == ' ' || name.charAt(name.length() - 1) == ' ') {
            return "{" + name + "}";
        }
        return name;
    }

    public static SimpleReference makeVariable(Expression variableName) {
        String name = null;
        int start = 0;
        int end = 0;
        if (variableName instanceof SimpleReference) {
            name = ((SimpleReference)variableName).getName();
        } else if (variableName instanceof TclBlockExpression) {
            name = ((TclBlockExpression)variableName).getBlock();
            name = TclParseUtil.nameFromBlock(name, '{', '}');
        } else if (variableName instanceof StringLiteral) {
            name = ((StringLiteral)variableName).getValue();
            name = TclParseUtil.nameFromBlock(name, '\"', '\"');
        } else if (variableName instanceof TclExecuteExpression) {
            name = ((TclExecuteExpression)variableName).getExpression();
        }
        if (name != null) {
            String fullName = TclParseUtil.escapeName(name);
            start = variableName.sourceStart();
            end = variableName.sourceEnd();
            return new SimpleReference(start, end, fullName);
        }
        return null;
    }

    public static TclStatement convertToAST(TclCommand command, String filename, int offset, String content, int startPos) {
        try {
            ArrayList<Object> exprs = new ArrayList<Object>();
            for (TclWord word : command.getWords()) {
                BracesSubstitution bs;
                Object o = word.getContents().get(0);
                String wordText = TclParseUtil.getWordText(word);
                if (o instanceof QuotesSubstitution) {
                    QuotesSubstitution qs = (QuotesSubstitution)o;
                    exprs.add(new StringLiteral(startPos + offset + qs.getStart(), startPos + offset + qs.getEnd() + 1, wordText));
                    continue;
                }
                if (o instanceof BracesSubstitution) {
                    bs = (BracesSubstitution)o;
                    wordText = content.substring(offset + word.getStart(), word.getEnd() + 1 + offset);
                    TclBlockExpression tclBlockExpression = new TclBlockExpression(startPos + offset + bs.getStart(), startPos + offset + bs.getEnd() + 1, wordText);
                    tclBlockExpression.setFilename(filename);
                    exprs.add((Object)tclBlockExpression);
                    continue;
                }
                if (o instanceof CommandSubstitution && word.getContents().size() == 1) {
                    bs = (CommandSubstitution)o;
                    exprs.add((Object)new TclExecuteExpression(startPos + offset + bs.getStart(), startPos + offset + bs.getEnd() + 1, wordText));
                    continue;
                }
                exprs.add(new SimpleReference(startPos + offset + word.getStart(), startPos + offset + word.getEnd() + 1, wordText));
            }
            TclStatement st = new TclStatement(exprs);
            return st;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    private static String getWordText(TclWord word) {
        StringBuffer buff = new StringBuffer();
        List contents = word.getContents();
        for (Object object : contents) {
            if (!(object instanceof String)) continue;
            buff.append((String)object);
        }
        return buff.toString();
    }

    public static void addToDeclaration(ASTNode decl, ASTNode node) {
        if (decl instanceof ModuleDeclaration && node instanceof Statement) {
            ((ModuleDeclaration)decl).addStatement((ASTNode)((Statement)node));
        } else if (decl instanceof TypeDeclaration) {
            ((TypeDeclaration)decl).getStatements().add(node);
        } else if (decl instanceof MethodDeclaration) {
            ((MethodDeclaration)decl).getStatements().add(node);
        } else if (decl instanceof Block) {
            ((Block)decl).addStatement(node);
        }
    }

    public static void removeFromDeclaration(ASTNode decl, ASTNode node) {
        if (decl instanceof ModuleDeclaration && node instanceof Statement) {
            ((ModuleDeclaration)decl).removeStatement((Statement)node);
        } else if (decl instanceof TypeDeclaration) {
            ((TypeDeclaration)decl).getStatements().remove(node);
        } else if (decl instanceof MethodDeclaration) {
            ((MethodDeclaration)decl).getStatements().remove(node);
        } else if (decl instanceof Block) {
            ((Block)decl).removeStatement(node);
        }
    }

    public static List<ASTNode> findLevelsTo(ModuleDeclaration module, ASTNode astNodeParent) {
        ArrayList<ASTNode> elements = new ArrayList<ASTNode>();
        if (module != null || astNodeParent instanceof ModuleDeclaration) {
            if (module == null) {
                module = (ModuleDeclaration)astNodeParent;
            }
            elements.add((ASTNode)module);
            TclParseUtil.findElementsTo(TclASTUtil.getStatements((ASTNode)module), astNodeParent, elements);
        }
        return elements;
    }

    public static void findElementsTo(List statements, ASTNode node, List elements) {
        if (statements == null) {
            return;
        }
        for (ASTNode n : statements) {
            if (n.equals(node)) {
                elements.add(n);
                return;
            }
            if (n.sourceStart() > node.sourceStart() || node.sourceEnd() > n.sourceEnd()) continue;
            elements.add(n);
            TclParseUtil.findElementsTo(TclASTUtil.getStatements(n), node, elements);
            return;
        }
    }

    public static TypeDeclaration findXOTclTypeDeclarationFrom(ModuleDeclaration module, ASTNode parent, String originalName) {
        return TclParseUtil.findTclTypeDeclarationFrom(module, parent, originalName, true);
    }

    public static TypeDeclaration findTclTypeDeclarationFrom(ModuleDeclaration module, ASTNode node) {
        List<ASTNode> levels;
        String name = TclParseUtil.getNameFromNode(node);
        if (name == null) {
            return null;
        }
        if (name.indexOf("::") != -1) {
            name = name.substring(0, name.lastIndexOf("::"));
        }
        if ((levels = TclParseUtil.findLevelsTo(module, node)).size() == 2) {
            return TclParseUtil.findTclTypeDeclarationFrom(module, (ASTNode)module, name, false);
        }
        if (levels.size() - 2 > 0) {
            return TclParseUtil.findTclTypeDeclarationFrom(module, levels.get(levels.size() - 2), name, false);
        }
        return null;
    }

    public static String getNameFromNode(ASTNode node) {
        if (node instanceof Declaration) {
            return ((Declaration)node).getName();
        }
        if (node instanceof SimpleReference) {
            return ((SimpleReference)node).getName();
        }
        return null;
    }

    public static TypeDeclaration findTclTypeDeclarationFrom(ModuleDeclaration module, ASTNode parent, String originalName, boolean onlyXOTcl) {
        String name = originalName;
        boolean startFromTop = false;
        if (name.startsWith("::")) {
            startFromTop = true;
            name = name.substring(2);
        }
        String[] split = TclParseUtil.tclSplit(name);
        name = split[split.length - 1];
        if (!startFromTop) {
            TypeDeclaration ty;
            ASTNode astNodeParent;
            List childs;
            List<ASTNode> levels = TclParseUtil.findLevelsTo(module, parent);
            int len = levels.size();
            if (len > 0 && (childs = TclASTUtil.getStatements(astNodeParent = levels.get(len - 1))) != null && (ty = TclParseUtil.findTclTypeCheckASTLevel(originalName, split, childs)) != null) {
                return ty;
            }
        } else {
            List childs = TclASTUtil.getStatements((ASTNode)module);
            if (childs == null) {
                return null;
            }
            TypeDeclaration ty = TclParseUtil.findTclTypeCheckASTLevel(originalName, split, childs);
            if (ty != null) {
                return ty;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static TypeDeclaration findTclTypeCheckASTLevel(String originalName, String[] split, List childs) {
        i = 0;
        while (i < childs.size()) {
            if (childs.get(i) instanceof TypeDeclaration) {
                type = (TypeDeclaration)childs.get(i);
                cName = split[0];
                tName = type.getName();
                if (tName.startsWith("::")) {
                    tName = tName.substring(2);
                }
                q = 1;
                while (q <= split.length) {
                    if (tName.equals(cName)) {
                        if (q == split.length) {
                            return type;
                        }
                        nsplit = new String[split.length - q];
                        System.arraycopy(split, q, nsplit, 0, split.length - q);
                        nchilds = TclASTUtil.getStatements((ASTNode)type);
                        if (childs != null) {
                            ty = TclParseUtil.findTclTypeCheckASTLevel(originalName, nsplit, nchilds);
                            if (ty != null) {
                                return ty;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (q != split.length) {
                        cName = String.valueOf(cName) + "::" + split[q];
                    }
                    ++q;
                }
                if (tName.equals(split[0]) && split.length == 1) {
                    return type;
                }
                if (split.length > 1) {
                    nchilds = TclASTUtil.getStatements((ASTNode)type);
                    if (childs != null) {
                        nsplit = new String[split.length - 1];
                        System.arraycopy(split, 1, nsplit, 0, split.length - 1);
                        ty = TclParseUtil.findTclTypeCheckASTLevel(originalName, nsplit, nchilds);
                        if (ty != null) {
                            return ty;
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static TypeDeclaration findTypesFromASTNode(ModuleDeclaration module, ASTNode node, String name) {
        List<ASTNode> levels = TclParseUtil.findLevelsTo(module, node);
        String[] split = TclParseUtil.tclSplit(name);
        int i = 0;
        while (i < levels.size() - 1) {
            ASTNode nde = levels.get(levels.size() - i - 2);
            if (nde instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)nde;
                if (split.length == 2 && type.getName().equals(split[0])) {
                    return type;
                }
                type.getTypes();
            }
            ++i;
        }
        return null;
    }

    public static String getElementFQN(ASTNode node, String separator, ModuleDeclaration module) {
        List<ASTNode> nodes = TclParseUtil.findLevelsTo(module, node);
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
        return TclParseUtil.getElementFQN(nodes, separator, module);
    }

    public static String getElementFQN(List<ASTNode> nodes, String separator, ModuleDeclaration module) {
        StringBuffer prefix = new StringBuffer();
        for (ASTNode ns : nodes) {
            String name = null;
            if (ns instanceof ModuleDeclaration) {
                name = "";
            } else if (ns instanceof TypeDeclaration) {
                name = ((TypeDeclaration)ns).getName();
                if (name.endsWith("::")) {
                    name = name.substring(0, name.length() - 2);
                }
            } else if (ns instanceof MethodDeclaration) {
                if (ns instanceof ExtendedTclMethodDeclaration) {
                    ExtendedTclMethodDeclaration m = (ExtendedTclMethodDeclaration)ns;
                    ASTNode declaringXOTclType = m.getDeclaringType();
                    if (declaringXOTclType != null) {
                        List<ASTNode> ndss = TclParseUtil.findLevelsTo(module, declaringXOTclType);
                        name = "::" + TclParseUtil.getElementFQN(ndss, separator, module) + separator + m.getName();
                    }
                } else {
                    name = ((MethodDeclaration)ns).getName();
                }
            } else if (ns instanceof FieldDeclaration) {
                name = ((FieldDeclaration)ns).getName();
            }
            if (name == null) continue;
            if (name.startsWith("::")) {
                prefix.delete(0, prefix.length());
                name = name.substring(2);
            }
            if (name.length() <= 0) continue;
            prefix.append(String.valueOf(TclParseUtil.tclNameTo(name, separator)) + separator);
        }
        String result = prefix.toString();
        if (result.endsWith(separator)) {
            return result.substring(0, result.length() - separator.length());
        }
        return result;
    }

    public static String tclNameTo(String name, String separator) {
        if (!separator.equals("::")) {
            name = name.replaceAll("::", separator);
        }
        return name;
    }

    public static String extractArrayName(String name) {
        int t1 = name.indexOf("(");
        if (t1 > 0 && name.charAt(t1 - 1) == '\\') {
            --t1;
        }
        return name.substring(0, t1);
    }

    public static String extractArrayIndex(String name) {
        String arrayIndex;
        int t1 = name.indexOf("(");
        if (t1 > 0 && name.charAt(t1 - 1) == '\\') {
            --t1;
        }
        if ((arrayIndex = name.substring(name.indexOf("(") + 1, name.length() - 1)).endsWith("\\")) {
            arrayIndex = arrayIndex.substring(0, arrayIndex.length() - 1);
        }
        return arrayIndex;
    }

    public static ASTNode getScopeParent(ModuleDeclaration module, ASTNode node) {
        List<ASTNode> levels = TclParseUtil.findLevelsTo(module, node);
        int i = 0;
        while (i < levels.size()) {
            ASTNode nde = levels.get(levels.size() - i - 1);
            if (nde instanceof TypeDeclaration || nde instanceof MethodDeclaration || nde instanceof ModuleDeclaration && nde instanceof Block) {
                return nde;
            }
            ++i;
        }
        return module;
    }

    public static ASTNode getPrevParent(ModuleDeclaration module, ASTNode declaringType) {
        ASTNode parent = TclParseUtil.getScopeParent(module, declaringType);
        if (parent instanceof ModuleDeclaration) {
            return parent;
        }
        List<ASTNode> levels = TclParseUtil.findLevelsTo(module, parent);
        return levels.get(levels.size() - 2);
    }

    public static List<ASTNode> findLevelFromModule(final ModuleDeclaration module, IMember member, final String memberFQN) {
        ArrayList<ASTNode> levels;
        block2: {
            levels = new ArrayList<ASTNode>();
            final HashSet processed = new HashSet();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visitGeneral(ASTNode s) throws Exception {
                    if (s instanceof Declaration) {
                        Declaration d = (Declaration)s;
                        String key = "::" + TclParseUtil.getElementFQN(s, "::", module);
                        if (key.equals(memberFQN) && processed.add(key)) {
                            levels.add(d);
                        }
                    }
                    return true;
                }
            };
            try {
                module.traverse(visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return levels;
    }

    public static String getNameFromModelElement(IModelElement member) {
        return TclParseUtil.getFQNFromModelElement(member, "::");
    }

    public static String getFQNFromModelElement(IModelElement member, String separator) {
        String buffer = new String();
        IModelElement m = member;
        while (m.getElementType() != 5) {
            buffer = String.valueOf(separator) + m.getElementName() + buffer;
            m = m.getParent();
        }
        return buffer;
    }

    public static String[] tclSplit(String text) {
        int len = text.length();
        if (len < 2) {
            return new String[]{text};
        }
        ArrayList<String> results = new ArrayList<String>();
        int pos = 0;
        int i = 0;
        while (i < len) {
            int c = 0;
            int j = i;
            while (j < len) {
                if (text.charAt(j) != ':') break;
                ++c;
                ++j;
            }
            if (c > 1) {
                if (pos <= i) {
                    results.add(text.substring(pos, i));
                }
                pos = i + c;
                i += c - 1;
            }
            ++i;
        }
        if (pos < len) {
            results.add(text.substring(pos, len));
        }
        if (results.isEmpty()) {
            results.add("");
        }
        return results.toArray(new String[results.size()]);
    }
}

