/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.ICodeSelection;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public abstract class AbstractScriptEditorTextHover
implements IScriptEditorTextHover,
ITextHoverExtension {
    private static String fgCSSStyles;
    private IEditorPart fEditor;
    private IPreferenceStore fStore;

    @Override
    public void setPreferenceStore(IPreferenceStore store) {
        this.fStore = store;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return ScriptWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String nature = null;
        ISourceModule inputModelElement = this.getEditorInputModelElement();
        if (inputModelElement == null) {
            return null;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)inputModelElement);
        if (toolkit == null) {
            return null;
        }
        nature = toolkit.getNatureId();
        if (nature == null) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            ICodeSelection result;
            block10: {
                try {
                    String content = null;
                    try {
                        content = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                    }
                    catch (BadLocationException badLocationException) {}
                    result = resolve.codeSelectAll(hoverRegion.getOffset(), hoverRegion.getLength());
                    if (result != null) break block10;
                    if (content != null) {
                        return this.getHoverInfo(nature, content);
                    }
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            return this.getHoverInfo(nature, result);
        }
        return null;
    }

    protected ISourceModule getEditorInputModelElement() {
        return EditorUtility.getEditorInputModelElement(this.fEditor, false);
    }

    @Deprecated
    protected String getHoverInfo(String nature, IModelElement[] modelElements) {
        return null;
    }

    protected String getHoverInfo(String nature, Object[] elements) {
        ArrayList<IModelElement> modelElements = new ArrayList<IModelElement>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IModelElement) {
                modelElements.add((IModelElement)element);
            }
            ++n2;
        }
        return this.getHoverInfo(nature, modelElements.toArray(new IModelElement[modelElements.size()]));
    }

    protected String getHoverInfo(String nature, ICodeSelection selection) {
        return this.getHoverInfo(nature, selection.toArray());
    }

    protected String getHoverInfo(String nature, String content) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    protected static String getStyleSheet() {
        String css;
        Bundle bundle;
        URL url;
        if (fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)DLTKUIPlugin.getPluginId())).getEntry("/DocumentationHoverStyleSheet.css")) != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgCSSStyles = buffer.toString();
            }
            catch (IOException ex) {
                DLTKUIPlugin.log(ex);
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont(css, fontData);
        }
        return css;
    }
}

