/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerWizard;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.WizardPropertyPage;

public class BuildpathContainerPreferencePage
extends WizardPropertyPage {
    private IScriptProject fJavaProject;
    private IBuildpathEntry fEntry;

    public BuildpathContainerPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        BuildPathContainer container = element instanceof BuildPathContainer ? (BuildPathContainer)element : (BuildPathContainer)element.getAdapter(BuildPathContainer.class);
        this.fJavaProject = container.getScriptProject();
        this.fEntry = container.getBuildpathEntry();
    }

    protected IWizard createWizard() {
        try {
            IScriptProject project = this.fJavaProject;
            IBuildpathEntry[] entries = project.getRawBuildpath();
            return new BuildpathContainerWizard(this.fEntry, project, entries);
        }
        catch (ModelException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
            return null;
        }
    }

    protected void applyChanges() {
        IBuildpathEntry[] created = ((BuildpathContainerWizard)this.getWizard()).getNewEntries();
        if (created == null || created.length != 1) {
            return;
        }
        IBuildpathEntry result = created[0];
        if (result == null || result.equals(this.fEntry)) {
            return;
        }
        try {
            IBuildpathEntry[] entries = this.fJavaProject.getRawBuildpath();
            int idx = BuildpathContainerPreferencePage.indexInClasspath(entries, this.fEntry);
            if (idx == -1) {
                return;
            }
            final IBuildpathEntry[] newEntries = new IBuildpathEntry[entries.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[idx] = result;
            ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
            context = PlatformUI.getWorkbench().getProgressService();
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        BuildpathContainerPreferencePage.this.fJavaProject.setRawBuildpath(newEntries, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.fEntry = result;
        }
        catch (ModelException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
        }
        catch (InvocationTargetException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_applyingfailed_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static int indexInClasspath(IBuildpathEntry[] entries, IBuildpathEntry entry) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].equals(entry)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

