/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.internal.core.RMethod;
import org.eclipse.dltk.javascript.internal.core.RParameter;
import org.eclipse.dltk.javascript.internal.core.TypeSystems;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;

public enum FunctionMethod {
    apply{

        @Override
        List<IRParameter> buildParameters(IRFunctionType functionType) {
            return Arrays.asList(new RParameter(FunctionMethod.FUNCTION_THIS_ARG, RTypes.any(), ParameterKind.OPTIONAL), new RParameter(FunctionMethod.FUNCTION_ARG_ARRAY, RTypes.arrayOf(TypeSystems.GLOBAL, RTypes.any()), ParameterKind.OPTIONAL));
        }
    }
    ,
    call{

        @Override
        List<IRParameter> buildParameters(IRFunctionType functionType) {
            ArrayList<IRParameter> parameters = new ArrayList<IRParameter>(functionType.getParameters().size() + 1);
            parameters.add(new RParameter(FunctionMethod.FUNCTION_THIS_ARG, RTypes.any(), this.isAllOptionall(functionType.getParameters()) ? ParameterKind.OPTIONAL : ParameterKind.NORMAL));
            for (IRParameter param : functionType.getParameters()) {
                parameters.add(new RParameter(FunctionMethod.FUNCTION_ARG + parameters.size(), param.getType(), param.getKind()));
            }
            return parameters;
        }

        boolean isAllOptionall(Collection<IRParameter> parameters) {
            for (IRParameter param : parameters) {
                if (param.getKind() != ParameterKind.NORMAL) continue;
                return false;
            }
            return true;
        }
    };

    private static final String FUNCTION_THIS_ARG = "thisArg";
    private static final String FUNCTION_ARG = "arg";
    private static final String FUNCTION_ARG_ARRAY = "argArray";

    private FunctionMethod() {
    }

    public boolean test(String name) {
        return this.name().equals(name);
    }

    public IRMethod create(IRFunctionType functionType) {
        return new RMethod((Method)Types.FUNCTION.findDirectMember(this.name()), functionType.getReturnType(), this.buildParameters(functionType), RTypes.FUNCTION.getDeclaration());
    }

    abstract List<IRParameter> buildParameters(IRFunctionType var1);

    /* synthetic */ FunctionMethod(String string, int n, FunctionMethod functionMethod) {
        this();
    }
}

