/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContainerType implements Enumerator
{
    LIBRARIES(0, "LIBRARIES", "LIBRARIES"),
    PACKAGES(1, "PACKAGES", "PACKAGES"),
    SOURCES(2, "SOURCES", "SOURCES");

    public static final int LIBRARIES_VALUE = 0;
    public static final int PACKAGES_VALUE = 1;
    public static final int SOURCES_VALUE = 2;
    private static final ContainerType[] VALUES_ARRAY;
    public static final List<ContainerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainerType[]{LIBRARIES, PACKAGES, SOURCES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerType get(int value) {
        switch (value) {
            case 0: {
                return LIBRARIES;
            }
            case 1: {
                return PACKAGES;
            }
            case 2: {
                return SOURCES;
            }
        }
        return null;
    }

    private ContainerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

