/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.net.URI;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;

public class DbgpStackLevel
implements IDbgpStackLevel {
    private final int level;
    private final int lineNumber;
    private final int methodOffset;
    private final String methodName;
    private final int beginLine;
    private final int beginColumn;
    private final int endLine;
    private final int endColumn;
    private final URI fileUri;
    private final String where;

    public DbgpStackLevel(URI fileUri, String where, int level, int lineNumber, int methodOffset, String methodName, int beginLine, int endLine) {
        this(fileUri, where, level, lineNumber, methodOffset, methodName, beginLine, -1, endLine, -1);
    }

    public DbgpStackLevel(URI fileUri, String where, int level, int lineNumber, int methodOffset, String methodName, int beginLine, int beginColumn, int endLine, int endColumn) {
        this.fileUri = fileUri;
        this.level = level;
        this.lineNumber = lineNumber;
        this.methodName = methodName;
        this.methodOffset = methodOffset;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.where = where;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int getMethodOffset() {
        return this.methodOffset;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public URI getFileURI() {
        return this.fileUri;
    }

    public String toString() {
        return "DbgpStackLevel(level: " + this.level + ", line: " + this.lineNumber + ", begin: " + this.beginLine + ", end: " + this.endLine + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fileUri == null ? 0 : this.fileUri.hashCode());
        result = 31 * result + this.level;
        result = 31 * result + this.beginLine;
        result = 31 * result + this.endLine;
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.where == null ? 0 : this.where.hashCode());
        return result;
    }

    private static boolean equals(URI u1, URI u2) {
        if (u1 == null) {
            return u2 == null;
        }
        return u1.equals(u2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbgpStackLevel)) {
            return false;
        }
        DbgpStackLevel other = (DbgpStackLevel)obj;
        if (!DbgpStackLevel.equals(this.fileUri, other.fileUri)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.beginLine != other.beginLine) {
            return false;
        }
        if (this.beginColumn != other.beginColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        return StrUtils.equals(this.where, other.where);
    }

    @Override
    public boolean isSameMethod(IDbgpStackLevel other) {
        return DbgpStackLevel.equals(this.fileUri, other.getFileURI()) && StrUtils.equals(this.where, other.getWhere());
    }
}

