/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IPunctuationConfiguration;

public class ArrayBracketsConfiguration
implements IBracketsConfiguration,
IPunctuationConfiguration {
    private IFormatterDocument document;
    private final JSNode node;

    public ArrayBracketsConfiguration(IFormatterDocument document, JSNode node) {
        this.document = document;
        this.node = node;
    }

    protected IFormatterDocument getDocument() {
        return this.document;
    }

    @Override
    public boolean isBeginLineBreaking() {
        if (!this.canBreak()) {
            return false;
        }
        String value = this.document.getString("formatter.braces.array");
        return "next.line".equals(value) || "next.line.indented".equals(value);
    }

    private boolean canBreak() {
        return !(this.node.getParent() instanceof ReturnStatement);
    }

    @Override
    public boolean isBracketsIndenting() {
        return "next.line.indented".equals(this.document.getString("formatter.braces.array"));
    }

    @Override
    public boolean isEndLineBreaking() {
        return false;
    }

    @Override
    public boolean isIndenting() {
        String value = this.document.getString("formatter.braces.array");
        return "next.line".equals(value) || "next.line.indented".equals(value);
    }

    @Override
    public boolean insertSpaceAfter() {
        return true;
    }

    @Override
    public boolean insertSpaceBefore() {
        return false;
    }
}

