/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.testing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractTestRunnerUI
implements ITestRunnerUI {
    @Override
    public boolean canFilterStack() {
        return false;
    }

    @Override
    public String filterStackTrace(String trace) {
        return trace;
    }

    @Override
    public boolean isStackFrame(String line) {
        return false;
    }

    @Override
    public IAction createOpenEditorAction(String traceLine) {
        return null;
    }

    @Override
    public String getTestCaseLabel(ITestCaseElement caseElement, boolean full) {
        String testName = caseElement.getTestName();
        int index = testName.indexOf(40);
        if (index > 0) {
            if (full) {
                int end = testName.length();
                if (end > index + 1 && testName.charAt(end - 1) == ')') {
                    --end;
                }
                String template = DLTKTestingMessages.TestSessionLabelProvider_testMethodName_className;
                return NLS.bind((String)template, (Object)testName.substring(index + 1, end), (Object)testName.substring(0, index));
            }
            return testName.substring(0, index);
        }
        index = testName.indexOf(64);
        if (index > 0) {
            if (full) {
                String template = DLTKTestingMessages.TestSessionLabelProvider_testMethodName_className;
                return NLS.bind((String)template, (Object)testName.substring(index + 1), (Object)testName.substring(0, index));
            }
            return testName.substring(0, index);
        }
        return testName;
    }

    @Override
    public String getTestStartedMessage(ITestCaseElement caseElement) {
        return caseElement.getTestName();
    }

    @Override
    public boolean canRerun(ITestElement testElement) {
        return false;
    }

    @Override
    public boolean canRerunFailures() {
        return false;
    }

    @Override
    public String collectFailures(ITestRunSession testRunSession) throws CoreException {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public boolean isFilterStack() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            return store.getBoolean("org.eclipse.dltk.testing.do_filter_stack");
        }
        return false;
    }

    @Override
    public void setFilterStack(boolean value) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            store.setValue("org.eclipse.dltk.testing.do_filter_stack", value);
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return DLTKTestingPlugin.getDefault().getPreferenceStore();
    }
}

