/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.search.processing.IJob;

public abstract class IndexRequest
implements IJob {
    protected boolean isCancelled = false;
    protected IPath containerPath;
    protected IndexManager manager;

    public IndexRequest(IPath containerPath, IndexManager manager) {
        this.containerPath = containerPath;
        this.manager = manager;
    }

    @Override
    public boolean belongsTo(String projectNameOrArchivePath) {
        return projectNameOrArchivePath.equals(this.containerPath.segment(0)) || projectNameOrArchivePath.equals(this.containerPath.toString());
    }

    @Override
    public void cancel() {
        this.manager.jobWasCancelled(this.containerPath);
        this.isCancelled = true;
    }

    @Override
    public void ensureReadyToRun() {
        this.manager.aboutToUpdateIndex(this.containerPath, this.updatedIndexState());
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }
}

