/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.List;
import org.eclipse.dltk.core.IImportContainer;
import org.eclipse.dltk.core.IImportDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.ImportDeclaration;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.utils.CorePrinter;

public class ImportContainer
extends SourceRefElement
implements IImportContainer {
    private final String containerName;

    protected ImportContainer(AbstractSourceModule parent, String containerName) {
        super(parent);
        this.containerName = containerName;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public String getElementName() {
        return this.getContainerName();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ImportContainer)) {
            return false;
        }
        ImportContainer other = (ImportContainer)o;
        if (!this.containerName.equals(other.containerName)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 11;
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '&': {
                if (memento.hasMoreTokens()) {
                    String importName = memento.nextToken();
                    String version = memento.nextToken();
                    String alias = memento.nextToken();
                    int type = Integer.parseInt(memento.nextToken());
                    int flags = Integer.parseInt(memento.nextToken());
                    if (version.length() == 0) {
                        version = null;
                    }
                    ModelElement importDecl = (ModelElement)((Object)this.getImport(importName, version, alias, type, flags));
                    return importDecl.getHandleFromMemento(memento, workingCopyOwner);
                }
                return this;
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '&';
    }

    @Override
    public IImportDeclaration getImport(String importName, String version) {
        return new ImportDeclaration(this, importName, version);
    }

    @Override
    public IImportDeclaration getImport(String importName, String version, String alias, int type, int flags) {
        return new ImportDeclaration(this, importName, version, alias, type, flags);
    }

    @Override
    public IImportDeclaration[] getImports() throws ModelException {
        List<IModelElement> list = this.getChildrenOfType(12);
        return list.toArray(new IImportDeclaration[list.size()]);
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        AbstractSourceModule cu = (AbstractSourceModule)this.parent;
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return new ImportContainer(cu, this.containerName);
    }

    @Override
    public ISourceRange getSourceRange() throws ModelException {
        IModelElement[] imports = this.getChildren();
        if (imports.length != 0) {
            ISourceRange firstRange = ((ISourceReference)((Object)imports[0])).getSourceRange();
            ISourceRange lastRange = ((ISourceReference)((Object)imports[imports.length - 1])).getSourceRange();
            return new SourceRange(firstRange.getOffset(), lastRange.getOffset() + lastRange.getLength() - firstRange.getOffset());
        }
        return null;
    }

    @Override
    protected void toString(int tab, StringBuffer buffer) {
        Object info = ModelManager.getModelManager().peekAtInfo(this);
        if (info == null || !(info instanceof ModelElementInfo)) {
            return;
        }
        IModelElement[] children = ((ModelElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                buffer.append("\n");
            }
            ((ModelElement)children[i]).toString(tab, buffer);
            ++i;
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("<import container>");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("<import container>" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public ISourceRange getNameRange() throws ModelException {
        return null;
    }
}

