/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.IndexerManager;
import org.eclipse.dltk.internal.core.index2.ProgressJob;

public class SourceModulesRequest
extends AbstractIndexRequest {
    private final IPath containerPath;
    private final Set<ISourceModule> sourceModules;

    public SourceModulesRequest(ProjectIndexer2 indexer, IPath containerPath, Set<ISourceModule> sourceModules, ProgressJob progressJob) {
        super(indexer, progressJob);
        this.containerPath = containerPath;
        this.sourceModules = sourceModules;
    }

    @Override
    protected String getName() {
        return this.containerPath.toString();
    }

    @Override
    protected void run() throws CoreException, IOException {
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null) {
            return;
        }
        HashSet<String> toRemove = new HashSet<String>();
        ArrayList<ISourceModule> toReindex = new ArrayList<ISourceModule>();
        this.analyzeSourceModuleChanges(this.containerPath, this.sourceModules, toRemove, toReindex);
        for (String path : toRemove) {
            indexer.removeDocument(this.containerPath, path);
        }
        Collections.sort(toReindex, new Comparator<ISourceModule>(){

            @Override
            public int compare(ISourceModule m1, ISourceModule m2) {
                return m1.getPath().toString().compareTo(m2.getPath().toString());
            }
        });
        for (ISourceModule sourceModule : toReindex) {
            this.reportToProgress(sourceModule);
            indexer.indexDocument(sourceModule);
        }
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.containerPath.toString());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.containerPath == null ? 0 : this.containerPath.hashCode());
        result = 31 * result + (this.sourceModules == null ? 0 : this.sourceModules.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceModulesRequest other = (SourceModulesRequest)obj;
        if (this.containerPath == null ? other.containerPath != null : !this.containerPath.equals((Object)other.containerPath)) {
            return false;
        }
        return !(this.sourceModules == null ? other.sourceModules != null : !this.sourceModules.equals(other.sourceModules));
    }
}

