/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.debug.ui;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.internal.debug.core.model.ScriptValue;
import org.eclipse.dltk.internal.debug.ui.ScriptDebugHover;
import org.eclipse.dltk.javascript.internal.debug.ui.JavaScriptDebugModelPresentation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;

public class JavaScriptDebugHover
extends ScriptDebugHover {
    protected ScriptDebugModelPresentation getModelPresentation() {
        return new JavaScriptDebugModelPresentation(){

            protected boolean isShowLabelDetails(IScriptValue value) {
                return true;
            }

            protected String getValueText(IScriptValue value) {
                String valueText = super.getValueText(value);
                if (valueText != null && valueText.length() > 400) {
                    valueText = String.valueOf(valueText.substring(0, 400)) + "...";
                }
                return valueText;
            }
        };
    }

    public void setPreferenceStore(IPreferenceStore store) {
    }

    protected String getFieldProperty(IField field) {
        return super.getFieldProperty(field);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        int maxPos;
        IScriptStackFrame frame = this.getFrame();
        if (frame == null) {
            return null;
        }
        String txt = textViewer.getDocument().get();
        int end = hoverRegion.getOffset();
        if (end < (maxPos = txt.length())) {
            while (end < maxPos) {
                char charAt = txt.charAt(end);
                if (Character.isJavaIdentifierPart(charAt) || charAt == ']') {
                    ++end;
                    continue;
                }
                break;
            }
        } else {
            end = maxPos;
        }
        int begin = hoverRegion.getOffset();
        int inBracket = 0;
        if (txt.charAt(end - 1) == ']') {
            ++inBracket;
        }
        while (begin > 0) {
            char charAt = txt.charAt(begin);
            if (inBracket > 0) {
                if (charAt == ']') {
                    ++inBracket;
                } else if (charAt == '[') {
                    --inBracket;
                }
                --begin;
                continue;
            }
            if (!Character.isJavaIdentifierPart(charAt)) {
                if (charAt == ']') {
                    ++inBracket;
                } else if (charAt != '.') break;
            }
            --begin;
        }
        if (inBracket > 0 || begin + 1 >= end) {
            return null;
        }
        String snippet = txt.substring(begin + 1, end);
        IDbgpCoreCommands propCmds = frame.getScriptThread().getDbgpSession().getCoreCommands();
        try {
            IDbgpProperty property = propCmds.getProperty(snippet, frame.getLevel());
            return this.getResultText(snippet, ScriptValue.createValue((IScriptStackFrame)frame, (IDbgpProperty)property));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

