/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;

public class TclDocumentScanner {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private final IDocument fDocument;
    private final String fPartitioning;
    private final String fPartition;
    private char fChar;
    private int fPos;
    private ITypedRegion fCachedPartition = new TypedRegion(-1, 0, "__no_partition_at_all");
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();

    public TclDocumentScanner(IDocument document, String partitioning, String partition) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        Assert.isLegal((partitioning != null ? 1 : 0) != 0);
        Assert.isLegal((partition != null ? 1 : 0) != 0);
        this.fDocument = document;
        this.fPartitioning = partitioning;
        this.fPartition = partition;
    }

    public TclDocumentScanner(IDocument document) {
        this(document, "__tcl_partitioning", "__dftl_partition_content_type");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findClosingPeer(int start, char openingPeer, char closingPeer) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        try {
            int depth = 1;
            --start;
            do {
                if ((start = this.scanForward(start + 1, -2, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == openingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findOpeningPeer(int start, char openingPeer, char closingPeer) {
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            int depth = 1;
            ++start;
            do {
                if ((start = this.scanBackward(start - 1, -2, new CharacterMatch(new char[]{openingPeer, closingPeer}))) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == closingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int findNonWhitespaceForward(int position, int bound) {
        return this.scanForward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, fNonWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this.fNonWSDefaultPart);
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this.fDocument.getLength();
        }
        Assert.isLegal((bound <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos < bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new CharacterMatch(ch));
    }

    public int scanForward(int position, int bound, char[] chars) {
        return this.scanForward(position, bound, new CharacterMatch(chars));
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isLegal((bound >= -1 ? 1 : 0) != 0);
        Assert.isLegal((start < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos > bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int position, int bound, char ch) {
        return this.scanBackward(position, bound, new CharacterMatch(ch));
    }

    public int scanBackward(int position, int bound, char[] chars) {
        return this.scanBackward(position, bound, new CharacterMatch(chars));
    }

    public boolean isDefaultPartition(int position) {
        return this.fPartition.equals(this.getPartition(position).getType());
    }

    private ITypedRegion getPartition(int position) {
        if (!this.contains((IRegion)this.fCachedPartition, position)) {
            Assert.isTrue((position >= 0 ? 1 : 0) != 0);
            Assert.isTrue((position <= this.fDocument.getLength() ? 1 : 0) != 0);
            try {
                this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)position, (boolean)false);
            }
            catch (BadLocationException badLocationException) {
                this.fCachedPartition = new TypedRegion(position, 0, "__no_partition_at_all");
            }
        }
        return this.fCachedPartition;
    }

    private boolean contains(IRegion region, int position) {
        int offset = region.getOffset();
        return offset <= position && position < offset + region.getLength();
    }

    public IRegion findSurroundingBlock(int offset) {
        if (offset < 1 || offset >= this.fDocument.getLength()) {
            return null;
        }
        int begin = this.findOpeningPeer(offset - 1, '{', '}');
        int end = this.findClosingPeer(offset, '{', '}');
        if (begin == -1 || end == -1) {
            return null;
        }
        return new Region(begin, end + 1 - begin);
    }

    private final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this.fChars = chars;
            Arrays.sort(chars);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this.fChars, ch) >= 0 && TclDocumentScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = TclDocumentScanner.this.getPartition(position);
            if (TclDocumentScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static class NonWhitespace
    extends StopCondition {
        private NonWhitespace() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && TclDocumentScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = TclDocumentScanner.this.getPartition(position);
            if (TclDocumentScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    private static abstract class StopCondition {
        private StopCondition() {
        }

        public abstract boolean stop(char var1, int var2, boolean var3);

        public int nextPosition(int position, boolean forward) {
            return forward ? position + 1 : position - 1;
        }
    }
}

