/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectTemplateEntry;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclWizardMessages;
import org.eclipse.dltk.ui.wizards.IProjectWizardInitializer;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TclProjectWizardFirstPage
extends ProjectWizardFirstPage {
    private final List<TclProjectTemplateEntry> fOptions;

    public TclProjectWizardFirstPage(List<TclProjectTemplateEntry> options) {
        this.setTitle(TclWizardMessages.ProjectCreationWizardFirstPage_title);
        this.setDescription(TclWizardMessages.ProjectCreationWizardFirstPage_description);
        this.fOptions = options;
    }

    protected boolean interpeterRequired() {
        return false;
    }

    protected TclProjectTemplateEntry getSelectedEntry() {
        for (TclProjectTemplateEntry entry : this.fOptions) {
            if (!entry.isSelected()) continue;
            return entry;
        }
        return null;
    }

    protected IStatus validateProject() {
        IStatus status = super.validateProject();
        if (status != null && !status.isOK()) {
            return status;
        }
        TclProjectTemplateEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return status;
        }
        return status;
    }

    protected ProjectWizardFirstPage.LocationGroup createLocationGroup() {
        return new TclLocationGroup();
    }

    public boolean getDetect() {
        return super.getDetect() || ((TclLocationGroup)this.fLocationGroup).getDetect();
    }

    private class TclLocationGroup
    extends ProjectWizardFirstPage.LocationGroup {
        private TclLocationGroup() {
            super((ProjectWizardFirstPage)TclProjectWizardFirstPage.this);
        }

        public void createControls(Composite composite) {
            if (TclProjectWizardFirstPage.this.fOptions.isEmpty()) {
                super.createControls(composite);
                return;
            }
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)TclProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(TclWizardMessages.TclProjectWizardFirstPage_LocationGroup_modeTitle);
            this.createModeControls((Composite)group, 3);
            for (TclProjectTemplateEntry entry : TclProjectWizardFirstPage.this.fOptions) {
                entry.fLinkRadio.setDialogFieldListener((IDialogFieldListener)this);
                entry.createControls((Composite)group, 3);
            }
            Group groupLocation = new Group(composite, 0);
            groupLocation.setLayoutData((Object)new GridData(768));
            groupLocation.setLayout((Layout)TclProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            groupLocation.setText(TclWizardMessages.TclProjectWizardFirstPage_LocationGroup_locationTitle);
            this.createEnvironmentControls((Composite)groupLocation, 3);
            this.createLocationControls((Composite)groupLocation, 3);
        }

        protected boolean isModeField(DialogField field, int kind) {
            if (super.isModeField(field, kind)) {
                return true;
            }
            if (kind == 0 || kind == 1) {
                for (TclProjectTemplateEntry entry : TclProjectWizardFirstPage.this.fOptions) {
                    if (field != entry.fLinkRadio) continue;
                    return true;
                }
            }
            return false;
        }

        protected void initialize() {
            IProjectWizardInitializer.IProjectWizardState state = TclProjectWizardFirstPage.this.getWizardState();
            String mode = state.getMode();
            if (mode == null) {
                super.initialize();
            } else {
                this.fWorkspaceRadio.setSelection("org.eclipse.dltk.ui.projectWizard.workspace".equals(mode));
                this.fExternalRadio.setSelection("org.eclipse.dltk.ui.projectWizard.external".equals(mode));
                for (TclProjectTemplateEntry entry : TclProjectWizardFirstPage.this.fOptions) {
                    entry.fLinkRadio.setSelection(entry.id.equals(mode));
                }
                if (state.getEnvironment() != null && this.canChangeEnvironment()) {
                    this.setEnvironment(state.getEnvironment());
                }
                if (state.getExternalLocation() != null && this.canChangeLocation()) {
                    this.fLocation.setText(state.getExternalLocation());
                }
            }
            this.setTooltip(this.fWorkspaceRadio, state.getToolTipText("org.eclipse.dltk.ui.projectWizard.workspace"));
            this.setTooltip(this.fExternalRadio, state.getToolTipText("org.eclipse.dltk.ui.projectWizard.external"));
            for (TclProjectTemplateEntry entry : TclProjectWizardFirstPage.this.fOptions) {
                this.setTooltip(entry.fLinkRadio, state.getToolTipText(entry.id));
            }
        }

        private void setTooltip(SelectionButtonDialogField radio, String tooltip) {
            radio.getSelectionButton().setToolTipText(tooltip);
        }

        public boolean isInWorkspace() {
            if (super.isInWorkspace()) {
                return true;
            }
            return TclProjectWizardFirstPage.this.getSelectedEntry() != null;
        }

        protected boolean canChangeEnvironment() {
            return super.canChangeEnvironment() || TclProjectWizardFirstPage.this.getSelectedEntry() != null;
        }

        boolean getDetect() {
            TclProjectTemplateEntry entry = TclProjectWizardFirstPage.this.getSelectedEntry();
            return entry != null && entry.getTemplate().getDetect();
        }
    }
}

