/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.structure;

import org.eclipse.dltk.itcl.internal.core.parser.structure.IncrTclNames;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IClass;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclModelBuilderDetector;
import org.eclipse.dltk.tcl.structure.TclModelBuilderUtil;

public class IncrTclModelDetector
extends TclModelBuilderUtil
implements ITclModelBuilderDetector {
    private static final String[] NAMESPACES = new String[]{"::itcl::", "itcl::"};
    private static final String[] COMMANDS = new String[]{"class", "body"};
    private static final String PREFIX = "#itcl#";
    private static final String ITCL_NEW_INSTANCE = "#itcl#$newInstance";

    private String normalize(String commandName) {
        String[] stringArray = NAMESPACES;
        int n = NAMESPACES.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            if (commandName.startsWith(namespace)) {
                return commandName.substring(namespace.length());
            }
            ++n2;
        }
        return commandName;
    }

    public String detect(String commandName, TclCommand command, ITclModelBuildContext context) {
        if (commandName == null) {
            return null;
        }
        commandName = this.normalize(commandName);
        String[] stringArray = COMMANDS;
        int n = COMMANDS.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (commandName.equals(cmd)) {
                return PREFIX + cmd;
            }
            ++n2;
        }
        return this.checkInstanceOperations(command, commandName, context);
    }

    private String checkInstanceOperations(TclCommand command, String commandName, ITclModelBuildContext context) {
        IClass type;
        IncrTclNames names = IncrTclNames.get(context);
        if (names != null && (type = names.resolve(commandName)) != null) {
            IncrTclNames.saveType(context, type);
            return ITCL_NEW_INSTANCE;
        }
        return null;
    }
}

