/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.editor;

import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ruby.internal.ui.text.RubyHeuristicScanner;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class RubyBracketInserter
extends BracketInserter {
    RubyBracketInserter(ScriptEditor scriptEditor) {
        super(scriptEditor);
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ITextEditorExtension3.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '\"': 
            case '\'': 
            case '(': 
            case '<': 
            case '[': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            int correctedOffset;
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            RubyHeuristicScanner scanner = new RubyHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
            int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
            int prevTokenOffset = scanner.getPosition();
            if (prevTokenOffset < 0) {
                prevTokenOffset = 0;
            }
            String previous = offset > 1 && prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            switch (event.character) {
                case '(': {
                    if (this.fCloseBrackets && nextToken != 5 && nextToken != 15 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '<': {
                    if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 12 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 15 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                    return;
                }
                case '[': {
                    if (this.fCloseBrackets && nextToken != 15 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '\"': 
                case '\'': {
                    if (this.fCloseStrings && nextToken != 15 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1 || previous.charAt(0) != event.character)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            int n = correctedOffset = document.getLength() > 0 && document.getLength() == offset ? offset - 1 : offset;
            if (!RubyBracketInserter.validatePartitioning((IDocument)document, (int)correctedOffset, (String)"__ruby_partitioning", (String[])new String[0])) {
                return;
            }
            if (!this.editor.validateEditorInputState()) {
                return;
            }
            this.insertBrackets(document, offset, length, event.character, RubyBracketInserter.getPeerCharacter((char)event.character));
            event.doit = false;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }
}

