/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.tcl.validators.ITclCheck;

public class ChecksExtensionManager {
    private static final String CATEGORY_ATTR = "category";
    private static final String COMMAND_ATTR = "command";
    private static final String CLASS_ATTR = "class";
    private static final String TITLE_ATTR = "title";
    private static final String ID_ATTR = "id";
    private static final String EXTENSION_ID = "org.eclipse.dltk.tcl.validators.tclCheck";
    private static ChecksExtensionManager sInstance;
    private List<TclCheckInfo> checks = new ArrayList<TclCheckInfo>();
    private boolean initialized = false;

    private void initialize() {
        IConfigurationElement[] configurationElements;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                String id = config.getAttribute(ID_ATTR);
                String title = config.getAttribute(TITLE_ATTR);
                ITclCheck check = (ITclCheck)config.createExecutableExtension(CLASS_ATTR);
                String commandName = config.getAttribute(COMMAND_ATTR);
                String category = config.getAttribute(CATEGORY_ATTR);
                TclCheckInfo info = new TclCheckInfo(check, commandName, id, title, category);
                this.checks.add(info);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public TclCheckInfo[] getChecks() {
        this.initialize();
        return this.checks.toArray(new TclCheckInfo[this.checks.size()]);
    }

    public static synchronized ChecksExtensionManager getInstance() {
        if (sInstance == null) {
            sInstance = new ChecksExtensionManager();
        }
        return sInstance;
    }

    public static class TclCheckInfo {
        private String id;
        private String title;
        private ITclCheck check;
        private String commandName;
        private String category;

        public TclCheckInfo(ITclCheck check, String commandName, String id, String title, String category) {
            this.check = check;
            this.commandName = commandName;
            this.id = id;
            this.title = title;
            this.category = category;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public ITclCheck getCheck() {
            return this.check;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getCategory() {
            return this.category;
        }
    }
}

