/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.internal.ui.ValidatorConsole;
import org.eclipse.dltk.validators.ui.ValidatorConsoleTrackerManager;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;

public class ConsoleValidatorOutput
implements IValidatorOutput {
    private final IOConsoleOutputStream stream;
    private boolean error = false;
    private final ValidatorConsole console;
    private boolean closed = false;

    public ConsoleValidatorOutput(String consoleName) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.removeTerminatedConsoles(consoleName, consoleManager);
        this.console = new ValidatorConsole(consoleName);
        IPatternMatchListener[] listeners = ValidatorConsoleTrackerManager.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.console.addPatternMatchListener(listeners[i]);
            ++i;
        }
        consoleManager.addConsoles(new IConsole[]{this.console});
        consoleManager.showConsoleView((IConsole)this.console);
        this.stream = this.console.newOutputStream();
    }

    private void removeTerminatedConsoles(String consoleName, IConsoleManager consoleManager) {
        IConsole[] consoles;
        ArrayList<IConsole> toRemove = null;
        IConsole[] iConsoleArray = consoles = consoleManager.getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorConsole vConsole;
            IConsole console = iConsoleArray[n2];
            if (console instanceof ValidatorConsole && (vConsole = (ValidatorConsole)console).isClosed() && consoleName.equals(vConsole.getBaseName())) {
                if (toRemove == null) {
                    toRemove = new ArrayList<IConsole>(consoles.length);
                }
                toRemove.add(console);
            }
            ++n2;
        }
        if (toRemove != null) {
            consoleManager.removeConsoles(toRemove.toArray(new IConsole[toRemove.size()]));
        }
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean checkError() {
        return this.error;
    }

    public void println(String x) {
        if (this.closed) {
            return;
        }
        try {
            this.stream.write(x);
            this.stream.write("\n");
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void close() {
        block3: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.stream.close();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        this.console.close();
    }

    public Object getAttribute(String name) {
        return this.console.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.console.setAttribute(name, value);
    }
}

