/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class TreeListDialogField
extends DialogField {
    protected TreeViewer fTree;
    protected ILabelProvider fLabelProvider;
    protected TreeViewerAdapter fTreeViewerAdapter;
    protected List fElements;
    protected ViewerComparator fViewerSorter;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    private Tree fTreeControl;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private ITreeListAdapter fTreeAdapter;
    private Object fParentElement;
    private int fTreeExpandLevel;

    public TreeListDialogField(ITreeListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
        this.fTreeAdapter = adapter;
        this.fLabelProvider = lprovider;
        this.fTreeViewerAdapter = new TreeViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = buttonLabels;
        if (this.fButtonLabels != null) {
            int nButtons = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[nButtons];
            int i = 0;
            while (i < nButtons) {
                this.fButtonsEnabled[i] = true;
                ++i;
            }
        }
        this.fTree = null;
        this.fTreeControl = null;
        this.fButtonsControl = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
        this.fTreeExpandLevel = 0;
    }

    public void setRemoveButtonIndex(int removeButtonIndex) {
        this.fRemoveButtonIndex = removeButtonIndex;
    }

    public void setUpButtonIndex(int upButtonIndex) {
        this.fUpButtonIndex = upButtonIndex;
    }

    public void setDownButtonIndex(int downButtonIndex) {
        this.fDownButtonIndex = downButtonIndex;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.fViewerSorter = viewerSorter;
    }

    public void setViewerComparator(ViewerComparator viewerComparator) {
        this.fViewerSorter = viewerComparator;
    }

    public void setTreeExpansionLevel(int level) {
        this.fTreeExpandLevel = level;
        if (this.isOkToUse((Control)this.fTreeControl) && this.fTreeExpandLevel > 0) {
            this.fTree.expandToLevel(level);
        }
    }

    private void buttonPressed(int index) {
        if (!this.managedButtonPressed(index) && this.fTreeAdapter != null) {
            this.fTreeAdapter.customButtonPressed(this, index);
        }
    }

    protected boolean managedButtonPressed(int index) {
        if (index == this.fRemoveButtonIndex) {
            this.remove();
        } else if (index == this.fUpButtonIndex) {
            this.up();
        } else if (index == this.fDownButtonIndex) {
            this.down();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        GridData gd = TreeListDialogField.gridDataForLabel(1);
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Control list = this.getTreeControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        gd.heightHint = converter.convertHeightInCharsToPixels(6);
        list.setLayoutData((Object)gd);
        Composite buttons = this.getButtonBox(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        buttons.setLayoutData((Object)gd);
        return new Control[]{label, list, buttons};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int minWidth) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = minWidth;
        }
    }

    public Control getTreeControl(Composite parent) {
        if (this.fTreeControl == null) {
            this.assertCompositeNotNull(parent);
            this.fTree = this.createTreeViewer(parent);
            this.fTreeControl = (Tree)this.fTree.getControl();
            this.fTreeControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    TreeListDialogField.this.handleKeyPressed(e);
                }
            });
            this.fTree.setContentProvider((IContentProvider)this.fTreeViewerAdapter);
            this.fTree.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTree.addSelectionChangedListener((ISelectionChangedListener)this.fTreeViewerAdapter);
            this.fTree.addDoubleClickListener((IDoubleClickListener)this.fTreeViewerAdapter);
            this.fTree.setInput(this.fParentElement);
            this.fTree.expandToLevel(this.fTreeExpandLevel);
            if (this.fViewerSorter != null) {
                this.fTree.setComparator(this.fViewerSorter);
            }
            this.fTreeControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTreeControl;
    }

    public TreeViewer getTreeViewer() {
        return this.fTree;
    }

    protected int getTreeStyle() {
        int style = 2818;
        return style;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, this.getTreeStyle());
        tree.setFont(parent.getFont());
        return new TreeViewer(tree);
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setFont(parent.getFont());
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    public Composite getButtonBox(Composite parent) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(parent);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    TreeListDialogField.this.doButtonSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    TreeListDialogField.this.doButtonSelected(e);
                }
            };
            Composite contents = new Composite(parent, 0);
            contents.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            contents.setLayout((Layout)layout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int i = 0;
                while (i < this.fButtonLabels.length) {
                    String currLabel = this.fButtonLabels[i];
                    if (currLabel != null) {
                        this.fButtonControls[i] = this.createButton(contents, currLabel, listener);
                        this.fButtonControls[i].setEnabled(this.isEnabled() && this.fButtonsEnabled[i]);
                    } else {
                        this.fButtonControls[i] = null;
                        this.createSeparator(contents);
                    }
                    ++i;
                }
            }
            this.fLastSeparator = this.createSeparator(contents);
            this.updateButtonState();
            this.fButtonsControl = contents;
        }
        return this.fButtonsControl;
    }

    private void doButtonSelected(SelectionEvent e) {
        if (this.fButtonControls != null) {
            int i = 0;
            while (i < this.fButtonControls.length) {
                if (e.widget == this.fButtonControls[i]) {
                    this.buttonPressed(i);
                    return;
                }
                ++i;
            }
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTree.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
            return;
        }
        this.fTreeAdapter.keyPressed(this, event);
    }

    @Override
    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null && this.isOkToUse((Control)this.fTreeControl) && this.fTreeControl.isEnabled()) {
            ISelection sel = this.fTree.getSelection();
            int i = 0;
            while (i < this.fButtonControls.length) {
                Button button = this.fButtonControls[i];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(this.isButtonEnabled(sel, i));
                }
                ++i;
            }
        }
    }

    protected boolean containsAttributes(List selected) {
        int i = 0;
        while (i < selected.size()) {
            if (!this.fElements.contains(selected.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean getManagedButtonState(ISelection sel, int index) {
        List selected = this.getSelectedElements();
        boolean hasAttributes = this.containsAttributes(selected);
        if (index == this.fRemoveButtonIndex) {
            return !selected.isEmpty() && !hasAttributes;
        }
        if (index == this.fUpButtonIndex) {
            return !sel.isEmpty() && !hasAttributes && this.canMoveUp(selected);
        }
        if (index == this.fDownButtonIndex) {
            return !sel.isEmpty() && !hasAttributes && this.canMoveDown(selected);
        }
        return true;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        boolean enabled = this.isEnabled();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            if (!enabled) {
                this.fSelectionWhenEnabled = this.fTree.getSelection();
                this.selectElements(null);
            } else {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTreeControl.setEnabled(enabled);
        }
        this.updateButtonState();
    }

    public void enableButton(int index, boolean enable) {
        if (this.fButtonsEnabled != null && index < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[index] = enable;
            this.updateButtonState();
        }
    }

    private boolean isButtonEnabled(ISelection sel, int index) {
        boolean extraState = this.getManagedButtonState(sel, index);
        return this.isEnabled() && extraState && this.fButtonsEnabled[index];
    }

    public void setElements(List elements) {
        this.fElements = new ArrayList(elements);
        this.refresh();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.expandToLevel(this.fTreeExpandLevel);
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int index) {
        return this.fElements.get(index);
    }

    public int getIndexOfElement(Object elem) {
        return this.fElements.indexOf(elem);
    }

    public void replaceElement(Object oldElement, Object newElement) throws IllegalArgumentException {
        int idx = this.fElements.indexOf(oldElement);
        if (idx != -1) {
            this.fElements.set(idx, newElement);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                List selected = this.getSelectedElements();
                if (selected.remove(oldElement)) {
                    selected.add(newElement);
                }
                boolean isExpanded = this.fTree.getExpandedState(oldElement);
                this.fTree.remove(oldElement);
                this.fTree.add(this.fParentElement, newElement);
                if (isExpanded) {
                    this.fTree.expandToLevel(newElement, this.fTreeExpandLevel);
                }
                this.selectElements((ISelection)new StructuredSelection(selected));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public boolean addElement(Object element) {
        if (this.fElements.contains(element)) {
            return false;
        }
        this.fElements.add(element);
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.add(this.fParentElement, element);
            this.fTree.expandToLevel(element, this.fTreeExpandLevel);
        }
        this.dialogFieldChanged();
        return true;
    }

    public boolean addElements(List elements) {
        int nElements = elements.size();
        if (nElements > 0) {
            ArrayList elementsToAdd = new ArrayList(nElements);
            int i = 0;
            while (i < nElements) {
                Object elem = elements.get(i);
                if (!this.fElements.contains(elem)) {
                    elementsToAdd.add(elem);
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty()) {
                this.fElements.addAll(elementsToAdd);
                if (this.isOkToUse((Control)this.fTreeControl)) {
                    this.fTree.add(this.fParentElement, elementsToAdd.toArray());
                    i = 0;
                    while (i < elementsToAdd.size()) {
                        this.fTree.expandToLevel(elementsToAdd.get(i), this.fTreeExpandLevel);
                        ++i;
                    }
                }
                this.dialogFieldChanged();
                return true;
            }
        }
        return false;
    }

    public void insertElementAt(Object element, int index) {
        if (this.fElements.contains(element)) {
            return;
        }
        this.fElements.add(index, element);
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.add(this.fParentElement, element);
            if (this.fTreeExpandLevel != -1) {
                this.fTree.expandToLevel(element, this.fTreeExpandLevel);
            }
        }
        this.dialogFieldChanged();
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            this.refresh();
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object element) throws IllegalArgumentException {
        if (this.fElements.remove(element)) {
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.remove(element);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List elements) {
        if (elements.size() > 0) {
            this.fElements.removeAll(elements);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.remove(elements.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection selection) {
        this.fSelectionWhenEnabled = selection;
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.setSelection(selection, true);
        }
    }

    public void selectFirstElement() {
        Object element = null;
        if (this.fViewerSorter != null) {
            Object[] arr = this.fElements.toArray();
            this.fViewerSorter.sort((Viewer)this.fTree, arr);
            if (arr.length > 0) {
                element = arr[0];
            }
        } else if (this.fElements.size() > 0) {
            element = this.fElements.get(0);
        }
        if (element != null) {
            this.selectElements((ISelection)new StructuredSelection(element));
        }
    }

    public void postSetSelection(final ISelection selection) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            Display d = this.fTreeControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TreeListDialogField.this.isOkToUse((Control)TreeListDialogField.this.fTreeControl)) {
                        TreeListDialogField.this.selectElements(selection);
                    }
                }
            });
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.refresh();
        }
    }

    public void refresh(Object element) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.refresh(element);
        }
    }

    public void update(Object element) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.update(element, null);
        }
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    private void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.fElements, toMoveUp));
            this.fTree.reveal(toMoveUp.get(0));
        }
    }

    private void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), toMoveDown)));
            this.fTree.reveal(toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private List reverse(List p) {
        ArrayList reverse = new ArrayList(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean canMoveUp(List selectedElements) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            int nSelected = selectedElements.size();
            int nElements = this.fElements.size();
            int i = 0;
            while (i < nElements && nSelected > 0) {
                if (!selectedElements.contains(this.fElements.get(i))) {
                    return true;
                }
                --nSelected;
                ++i;
            }
        }
        return false;
    }

    private boolean canMoveDown(List selectedElements) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            int nSelected = selectedElements.size();
            int i = this.fElements.size() - 1;
            while (i >= 0 && nSelected > 0) {
                if (!selectedElements.contains(this.fElements.get(i))) {
                    return true;
                }
                --nSelected;
                --i;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection selection;
        ArrayList result = new ArrayList();
        if (this.isOkToUse((Control)this.fTreeControl) && (selection = this.fTree.getSelection()) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    public void expandElement(Object element, int level) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.expandToLevel(element, level);
        }
    }

    protected void doListSelected(SelectionChangedEvent event) {
        this.updateButtonState();
        if (this.fTreeAdapter != null) {
            this.fTreeAdapter.selectionChanged(this);
        }
    }

    protected void doDoubleClick(DoubleClickEvent event) {
        if (this.fTreeAdapter != null) {
            this.fTreeAdapter.doubleClicked(this);
        }
    }

    private class TreeViewerAdapter
    implements ITreeContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return TreeListDialogField.this.fElements.toArray();
        }

        public Object[] getChildren(Object element) {
            if (TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.getChildren(TreeListDialogField.this, element);
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            if (!TreeListDialogField.this.fElements.contains(element) && TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.getParent(TreeListDialogField.this, element);
            }
            return TreeListDialogField.this.fParentElement;
        }

        public boolean hasChildren(Object element) {
            if (TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.hasChildren(TreeListDialogField.this, element);
            }
            return false;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeListDialogField.this.doListSelected(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            TreeListDialogField.this.doDoubleClick(event);
        }
    }
}

