/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class FormatterIndentationGroup {
    private Combo tabPolicy;
    private Text indentSize;
    private Text tabSize;
    private final String[] tabPolicyItems = new String[]{"space", "tab", "mixed"};
    private TabPolicyListener tabPolicyListener;

    public FormatterIndentationGroup(IFormatterControlManager manager, Composite parent) {
        Group tabPolicyGroup = SWTFactory.createGroup(parent, FormatterMessages.IndentationTabPage_generalSettings, 2, 1, 768);
        this.tabPolicy = manager.createCombo((Composite)tabPolicyGroup, "formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabPolicyItems, new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED});
        this.tabPolicyListener = new TabPolicyListener(manager);
        this.tabPolicy.addSelectionListener((SelectionListener)this.tabPolicyListener);
        manager.addInitializeListener(this.tabPolicyListener);
        this.indentSize = manager.createNumber((Composite)tabPolicyGroup, "formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size);
        this.tabSize = manager.createNumber((Composite)tabPolicyGroup, "formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size);
        this.tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = FormatterIndentationGroup.this.tabPolicy.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(FormatterIndentationGroup.this.tabPolicyItems[index]))) {
                    FormatterIndentationGroup.this.indentSize.setText(FormatterIndentationGroup.this.tabSize.getText());
                }
            }
        });
    }

    private class TabPolicyListener
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private final IFormatterControlManager manager;

        public TabPolicyListener(IFormatterControlManager manager) {
            this.manager = manager;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = FormatterIndentationGroup.this.tabPolicy.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(FormatterIndentationGroup.this.tabPolicyItems[index]);
                this.manager.enableControl((Control)FormatterIndentationGroup.this.indentSize, !tabMode);
            }
        }

        @Override
        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString("formatter.tabulation.char"));
            this.manager.enableControl((Control)FormatterIndentationGroup.this.indentSize, !tabMode);
        }
    }
}

