/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedSet<E>
extends AbstractSet<E> {
    private final Set<E>[] children;

    public CombinedSet(Set<E> ... children) {
        this.children = children;
    }

    @Override
    public boolean contains(Object o) {
        Set<E>[] setArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Set<E> child = setArray[n2];
            if (child.contains(o)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.children.length == 0) {
            return Collections.emptySet().iterator();
        }
        if (this.children.length == 1) {
            return this.children[0].iterator();
        }
        HashSet<E> temp = new HashSet<E>();
        Set<E>[] setArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Set<E> child = setArray[n2];
            temp.addAll(child);
            ++n2;
        }
        return temp.iterator();
    }

    @Override
    public int size() {
        if (this.children.length == 0) {
            return 0;
        }
        if (this.children.length == 1) {
            return this.children[0].size();
        }
        if (this.children.length == 2) {
            int size = this.children[0].size();
            for (E e : this.children[1]) {
                if (this.children[0].contains(e)) continue;
                ++size;
            }
            return size;
        }
        HashSet<E> temp = new HashSet<E>();
        Set<E>[] setArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Set<E> child = setArray[n2];
            temp.addAll(child);
            ++n2;
        }
        return temp.size();
    }
}

