/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class JSModelLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    private final ImageDescriptorRegistry registry = new ImageDescriptorRegistry(false);

    public Image getImage(Object element) {
        if (element instanceof IMember) {
            int flags;
            IMember method = (IMember)element;
            try {
                flags = method.getFlags();
            }
            catch (ModelException modelException) {
                flags = 0;
            }
            if ((flags & 0x40000) != 0) {
                ImageDescriptor imageDescriptor = null;
                ImageDescriptor[] overlay = new ImageDescriptor[5];
                overlay[4] = DLTKPluginImages.DESC_OVR_DEPRECATED;
                if (element instanceof IMethod) {
                    try {
                        if (((IMethod)element).isConstructor()) {
                            overlay[1] = DLTKPluginImages.DESC_OVR_CONSTRUCTOR;
                        }
                    }
                    catch (ModelException modelException) {}
                    imageDescriptor = ScriptElementImageProvider.getMethodImageDescriptor((int)flags);
                } else {
                    imageDescriptor = element instanceof IField ? ScriptElementImageProvider.getFieldImageDescriptor((int)flags) : ScriptElementImageProvider.getTypeImageDescriptor((int)flags, (boolean)false);
                }
                return this.registry.get((ImageDescriptor)new DecorationOverlayIcon(this.registry.get(imageDescriptor), overlay));
            }
        }
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public void dispose() {
        this.registry.dispose();
        super.dispose();
    }
}

