/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.io.StringReader;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.AbstractJavaScriptHighlighter;
import org.eclipse.dltk.javascript.internal.ui.text.Token;
import org.eclipse.dltk.javascript.internal.ui.text.XMLTokenizer;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.ui.editor.highlighting.AbortSemanticHighlightingException;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;

public class JavaScriptXmlHighlighter
extends AbstractJavaScriptHighlighter
implements ISemanticHighlighter {
    private static final String HL_XML_TAG = "XML_TAG_NAME";
    private static final String HL_XML_ATTRIBUTE = "XML_ATTR_NAME";
    private static final String HL_XML_COMMENT = "XML_COMMENT_NAME";
    private static final String HL_KEYWORD = "DLTK_keyword";
    private static final String HL_REGEXP = "JS_REGEXP";
    private static final String HL_PROPERTY = "JS_PROPERTY";

    public String[] getHighlightingKeys() {
        return new String[]{HL_XML_TAG, HL_XML_ATTRIBUTE, HL_XML_COMMENT, HL_KEYWORD, HL_REGEXP, HL_PROPERTY};
    }

    public void process(IModuleSource code, ISemanticHighlightingRequestor requestor) {
        Script declaration = JavaScriptParserUtil.parse((IModuleSource)code, null);
        if (declaration == null) {
            throw new AbortSemanticHighlightingException();
        }
        try {
            declaration.traverse((ASTVisitor)new HighlightingVisitor(requestor));
        }
        catch (Exception e) {
            JavaScriptUI.log(e);
        }
    }

    static class HighlightingVisitor
    extends ASTVisitor {
        final ISemanticHighlightingRequestor requestor;
        final boolean bPropertyNames = JavaScriptXmlHighlighter.isSemanticHighlightingEnabled("JS_PROPERTY");

        public HighlightingVisitor(ISemanticHighlightingRequestor requestor) {
            this.requestor = requestor;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node instanceof XmlLiteral) {
                this.handleXML((XmlLiteral)node);
            } else if (node instanceof Method) {
                this.handleMethod((Method)node);
            } else if (node instanceof RegExpLiteral) {
                this.handleRegExp((RegExpLiteral)node);
            } else if (node instanceof PropertyInitializer) {
                if (this.bPropertyNames) {
                    this.handlePropertyInitializer((PropertyInitializer)node);
                }
            } else if (node instanceof ForEachInStatement) {
                this.handleForEachIn((ForEachInStatement)node);
            }
            return true;
        }

        private void handleXML(XmlLiteral literal) {
            for (XmlFragment fragment : literal.getFragments()) {
                if (!(fragment instanceof XmlTextFragment)) continue;
                XMLTokenizer tokenizer = new XMLTokenizer(new StringReader(((XmlTextFragment)fragment).getXml()));
                int offset = fragment.sourceStart();
                List tokens = tokenizer.getRegions();
                for (Token token : tokens) {
                    if (token.context == "5") {
                        HighlightingVisitor.addRange(this.requestor, offset, token, JavaScriptXmlHighlighter.HL_XML_TAG);
                        continue;
                    }
                    if (token.context == "28") {
                        HighlightingVisitor.addRange(this.requestor, offset, token, JavaScriptXmlHighlighter.HL_XML_ATTRIBUTE);
                        continue;
                    }
                    if (token.context == "16" || token.context == "8" || token.context == "17") {
                        HighlightingVisitor.addRange(this.requestor, offset, token, JavaScriptXmlHighlighter.HL_XML_COMMENT);
                        continue;
                    }
                    String cfr_ignored_0 = token.context;
                }
            }
        }

        private void handleMethod(Method method) {
            Keyword keyword;
            if (method instanceof GetMethod) {
                keyword = ((GetMethod)method).getGetKeyword();
            } else if (method instanceof SetMethod) {
                keyword = ((SetMethod)method).getSetKeyword();
            } else {
                return;
            }
            this.requestor.addPosition(keyword.sourceStart(), keyword.sourceEnd(), JavaScriptXmlHighlighter.HL_KEYWORD);
        }

        private void handleForEachIn(ForEachInStatement forEach) {
            Keyword keyword = forEach.getEachKeyword();
            this.requestor.addPosition(keyword.sourceStart(), keyword.sourceEnd(), JavaScriptXmlHighlighter.HL_KEYWORD);
        }

        private void handleRegExp(RegExpLiteral regExp) {
            this.requestor.addPosition(regExp.sourceStart(), regExp.sourceEnd(), JavaScriptXmlHighlighter.HL_REGEXP);
        }

        private void handlePropertyInitializer(PropertyInitializer property) {
            Expression name = property.getName();
            if (name instanceof Identifier || name instanceof StringLiteral) {
                this.requestor.addPosition(name.sourceStart(), name.sourceEnd(), JavaScriptXmlHighlighter.HL_PROPERTY);
            }
        }

        private static void addRange(ISemanticHighlightingRequestor requestor, int start, Token token, String highlightingKey) {
            requestor.addPosition(start + token.start, start + token.start + token.textLength, highlightingKey);
        }
    }
}

