/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.typeinfo;

import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.ui.typeinfo.ElementLabelProviderRegistry;
import org.eclipse.dltk.javascript.ui.typeinfo.IElementLabelProvider;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public final class ElementLabelProvider
extends LabelProvider {
    private final ImageDescriptorRegistry registry = new ImageDescriptorRegistry(false);

    public String getText(Object element) {
        if (element instanceof Element) {
            Element el = (Element)element;
            String label = ElementLabelProviderRegistry.getLabel(el, IElementLabelProvider.Mode.TITLE);
            if (label != null) {
                return label;
            }
            return el.getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Element) {
            ImageDescriptor desc;
            Element el = (Element)element;
            ImageDescriptor descriptor = ElementLabelProviderRegistry.getImageDescriptor(el);
            if (descriptor != null) {
                return this.registry.get(descriptor);
            }
            if (element instanceof Type) {
                desc = ScriptElementImageProvider.getTypeImageDescriptor((int)0, (boolean)false);
            } else if (element instanceof Member) {
                int flags = ((Member)element).getVisibility().getFlags();
                if (element instanceof Property) {
                    desc = ScriptElementImageProvider.getFieldImageDescriptor((int)flags);
                } else {
                    assert (element instanceof Method);
                    desc = ScriptElementImageProvider.getMethodImageDescriptor((int)flags);
                }
            } else {
                desc = ImageDescriptor.getMissingImageDescriptor();
            }
            return this.registry.get(this.decorateImageDescriptor(desc, el));
        }
        return super.getImage(element);
    }

    protected ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, Element element) {
        if (element.isDeprecated()) {
            return new ScriptElementImageDescriptor(descriptor, 1024, ScriptElementImageProvider.SMALL_SIZE);
        }
        if (element instanceof Member && ((Member)element).isStatic()) {
            return new ScriptElementImageDescriptor(descriptor, 8, ScriptElementImageProvider.SMALL_SIZE);
        }
        return descriptor;
    }

    public void dispose() {
        this.registry.dispose();
        super.dispose();
    }
}

