/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.rename;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameModelElementProcessor;
import org.eclipse.dltk.internal.javascript.corext.refactoring.Checks;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.javascript.core.JavaScriptLanguageToolkit;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameFunctionProcessor
extends RenameModelElementProcessor {
    public static final String IDENTIFIER = "org.eclipse.dltk.javascript.renameFunctionProcessor";

    public RenameFunctionProcessor(IModelElement function) {
        super(function, JavaScriptLanguageToolkit.getDefault());
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        return Checks.validateIdentifier(newName);
    }

    public boolean isApplicable() throws CoreException {
        if (!Checks.isAvailable(this.fModelElement)) {
            return false;
        }
        Assert.isTrue((boolean)(this.fModelElement instanceof IMethod));
        IMethod method = (IMethod)this.fModelElement;
        return !"".equals(method.getElementName());
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameMethodRefactoring_name;
    }
}

