/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.VariableValue;
import org.eclipse.dltk.tcl.internal.core.packages.TclVariableResolver;

public class DefaultVariablesRegistry
implements TclVariableResolver.IVariableRegistry {
    private Map<String, VariableValue> variables = new HashMap<String, VariableValue>();
    private boolean environmentCalculated = false;
    private Map<String, String> environmentVariablesMap;
    private EnvironmentVariable[] interpreterVariables;
    private IInterpreterInstall install;

    public DefaultVariablesRegistry(IScriptProject project) {
        try {
            this.install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        }
        catch (CoreException e) {
            DLTKCore.error((String)"Failed to get interpreter install", (Throwable)e);
        }
        if (this.install != null) {
            this.variables.putAll(TclPackagesManager.getVariablesEMap(this.install).map());
            this.interpreterVariables = this.install.getEnvironmentVariables();
        }
        this.variables.putAll(TclPackagesManager.getVariablesEMap(project.getElementName()).map());
    }

    public String getValue(String name, String index) {
        VariableValue value;
        if (name.equals("env") && index != null) {
            if (this.interpreterVariables != null) {
                EnvironmentVariable[] environmentVariableArray = this.interpreterVariables;
                int n = this.interpreterVariables.length;
                int n2 = 0;
                while (n2 < n) {
                    EnvironmentVariable variable = environmentVariableArray[n2];
                    if (variable.getName().equals(index)) {
                        return variable.getValue();
                    }
                    ++n2;
                }
            }
            if (!this.environmentCalculated) {
                IExecutionEnvironment execEnvironment = this.install.getExecEnvironment();
                if (execEnvironment != null) {
                    this.environmentVariablesMap = execEnvironment.getEnvironmentVariables(true);
                }
                this.environmentCalculated = true;
            }
            if (this.environmentVariablesMap != null) {
                return this.environmentVariablesMap.get(index);
            }
        }
        if ((value = this.variables.get(name)) != null) {
            return value.getValue();
        }
        return null;
    }
}

