/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclCorePreferences;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageFragment;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclPackagesModelProvider
implements IModelProvider {
    public void provideModelChanges(IModelElement parentElement, List children) {
        if (parentElement.getElementType() == 2) {
            ScriptProject project = (ScriptProject)parentElement;
            TclSourcesFragment fragment = new TclSourcesFragment((ScriptProject)parentElement);
            if (!children.contains((Object)fragment)) {
                children.add(fragment);
            }
            if (!TclCorePreferences.USE_PACKAGE_CONCEPT) {
                return;
            }
            HashSet<String> realRequirements = new HashSet<String>();
            TclPackagesModelProvider.collectRealRequirements((IScriptProject)project, realRequirements);
            IInterpreterInstall install = TclPackagesModelProvider.resolveInterpreterInstall((IScriptProject)project);
            if (install == null) {
                return;
            }
            List<TclPackageInfo> infos = TclPackagesManager.getPackageInfos(install, realRequirements, true);
            for (TclPackageInfo packageName : infos) {
                TclPackageFragment pfragment = new TclPackageFragment((ScriptProject)parentElement, packageName.getName());
                if (children.contains((Object)pfragment)) continue;
                children.add(pfragment);
            }
        }
    }

    public static void collectRealRequirements(IScriptProject project, Set<String> realRequirements) {
        HashSet set = new HashSet();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, set, set);
        realRequirements.addAll(set);
    }

    public static IInterpreterInstall resolveInterpreterInstall(IScriptProject project) {
        block10: {
            try {
                IInterpreterInstall install = null;
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
                if (install != null) {
                    return install;
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block10;
                e.printStackTrace();
            }
        }
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getRawBuildpath();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        IBuildpathEntry[] iBuildpathEntryArray = buildpath;
        int n = buildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            IPath path = entry.getPath();
            if (path.segmentCount() > 0 && path.segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
                try {
                    IInterpreterInstall interp = InterpreterContainerInitializer.resolveInterpreter((String)InterpreterContainerInitializer.getNatureFromProject((IScriptProject)project), (String)InterpreterContainerInitializer.getEnvironmentFromProject((IScriptProject)project), (IPath)path);
                    if (interp == null) break;
                    return interp;
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break;
                    e.printStackTrace();
                }
                break;
            }
            ++n2;
        }
        return null;
    }

    public boolean isModelChangesProvidedFor(IModelElement modelElement, String name) {
        return modelElement.getElementType() == 2;
    }
}

