/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.compiler.problem.ValidationStatus;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.ti.FunctionMethod;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionPath;
import org.eclipse.dltk.internal.javascript.validation.MemberValidationEvent;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.core.NodeFinder;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.internal.core.codeassist.CompletionVisitor;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.core.codeassist.JavaScriptCompletionUtil;
import org.eclipse.dltk.javascript.internal.core.codeassist.PositionCalculator;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueParent;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRElement;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicates;
import org.eclipse.dltk.javascript.typeinfo.RTypeMemberQuery;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.validation.IValidatorExtension;

public class JavaScriptCompletionEngine2
extends ScriptCompletionEngine
implements JSCompletionEngine {
    private int globalOptions = 3;

    @Override
    public int getGlobalOptions() {
        return this.globalOptions;
    }

    @Override
    public void setGlobalOptions(int value) {
        this.globalOptions = value;
    }

    public void complete(IModuleSource cu, final int position, int i) {
        this.requestor.beginReporting();
        final String content = cu.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        final TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement(cu.getModelElement());
        final Script script = JavaScriptParserUtil.parse((IModuleSource)cu, null);
        final NodeFinder nodeFinder = new NodeFinder(position, position);
        nodeFinder.locate(script);
        if (nodeFinder.getNode() instanceof StringLiteral) {
            return;
        }
        final PositionCalculator calculator = new PositionCalculator(content, position, false);
        final CompletionVisitor visitor = new CompletionVisitor(inferencer2, position);
        inferencer2.setVisitor(visitor);
        if (cu instanceof ISourceModule) {
            inferencer2.setModelElement((IModelElement)((ISourceModule)cu));
        }
        try {
            inferencer2.doInferencing(script);
        }
        catch (PositionReachedException positionReachedException) {}
        ITypeSystem.CURRENT.runWith((ITypeSystem)inferencer2, new Runnable(){

            @Override
            public void run() {
                CompletionPath path = new CompletionPath(calculator.getCompletion());
                ASTNode node = nodeFinder.getNode();
                if (node instanceof Identifier) {
                    JavaScriptCompletionEngine2.this.setSourceRange(node.start(), node.end());
                } else {
                    String lastSegment = path.lastSegment();
                    if (lastSegment == null) {
                        lastSegment = "";
                    }
                    JavaScriptCompletionEngine2.this.setSourceRange(position - lastSegment.length(), position);
                }
                Reporter reporter = new Reporter(inferencer2, path.lastSegment(), position, TypeInfoManager.createExtensions(inferencer2, IValidatorExtension.class, null));
                if (calculator.isMember() && !path.isEmpty() && path.lastSegment() != null) {
                    JavaScriptCompletionEngine2.this.doCompletionOnMember(inferencer2, visitor.getCollection(), path, reporter);
                } else {
                    JavaScriptCompletionEngine2.this.doGlobalCompletion(visitor.getCollection(), reporter, JavaScriptCompletionUtil.evaluateExpressionContext(script, (CharSequence)content, position));
                }
            }
        });
        this.requestor.endReporting();
    }

    @Override
    public void completeTypes(ISourceModule module, TypeMode mode, String prefix, int offset) {
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement((IModelElement)module);
        Script script = JavaScriptParserUtil.parse((ISourceModule)module, null);
        inferencer2.doInferencing(script);
        this.setSourceRange(offset - prefix.length(), offset);
        this.doCompletionOnType(mode, new Reporter(inferencer2, prefix, offset, Collections.<IValidatorExtension>emptyList()));
    }

    @Override
    public void completeGlobals(ISourceModule module, final String prefix, final int offset, boolean jsdoc) {
        CompletionContext completionContext = new CompletionContext();
        completionContext.setOffset(offset);
        completionContext.setDoc(jsdoc);
        this.requestor.acceptContext(completionContext);
        this.setSourceRange(offset - prefix.length(), offset);
        final TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement((IModelElement)module);
        final CompletionVisitor visitor = new CompletionVisitor(inferencer2, Integer.MAX_VALUE);
        inferencer2.setVisitor(visitor);
        Script script = JavaScriptParserUtil.parse((ISourceModule)module, null);
        try {
            inferencer2.doInferencing(script);
        }
        catch (PositionReachedException positionReachedException) {}
        ITypeSystem.CURRENT.runWith((ITypeSystem)inferencer2, new Runnable(){

            @Override
            public void run() {
                Reporter reporter = new Reporter(inferencer2, prefix, offset, TypeInfoManager.createExtensions(inferencer2, IValidatorExtension.class, null));
                JavaScriptCompletionEngine2.this.doGlobalCompletion(visitor.getCollection(), reporter, null);
            }
        });
    }

    @Override
    public void completeMembers(ISourceModule module, String prefix, int offset, boolean jsdoc, Iterable<IRMember> memers) {
        CompletionContext completionContext = new CompletionContext();
        completionContext.setOffset(offset);
        completionContext.setDoc(jsdoc);
        this.requestor.acceptContext(completionContext);
        this.setSourceRange(offset - prefix.length(), offset);
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement((IModelElement)module);
        Reporter reporter = new Reporter(inferencer2, prefix, offset, TypeInfoManager.createExtensions(inferencer2, IValidatorExtension.class, null));
        for (IRMember member : memers) {
            String name = member.getName();
            if (!reporter.matches(name)) continue;
            reporter.report(name, member);
        }
    }

    private void doCompletionOnType(TypeMode mode, Reporter reporter) {
        ITypeInferenceContext context = reporter.context;
        Set<String> typeNames = context.listTypes(mode, reporter.getPrefix());
        for (String typeName : typeNames) {
            Type type = context.getType(typeName);
            if (type == null || !type.isVisible()) continue;
            reporter.reportTypeRef(type);
        }
    }

    private static boolean exists(IValueParent item) {
        if (item instanceof IValueReference) {
            return ((IValueReference)item).exists();
        }
        return true;
    }

    void doCompletionOnMember(ITypeInferenceContext context, IValueCollection collection, CompletionPath path, Reporter reporter) {
        IValueParent item = collection;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            if (path.isName(i)) {
                String segment = path.segment(i);
                item = "this".equals(segment) && item instanceof IValueCollection ? ((IValueCollection)item).getThis() : item.getChild(segment);
                if (!JavaScriptCompletionEngine2.exists(item)) {
                    break;
                }
            } else if (path.isFunction(i)) {
                if (!JavaScriptCompletionEngine2.exists(item = item.getChild("()"))) {
                    break;
                }
            } else {
                if (path.isObject(i)) {
                    item = item.getChild("Object").getChild("()");
                    break;
                }
                assert (path.isArray(i));
                if (!JavaScriptCompletionEngine2.exists(item = item.getChild("[]"))) break;
            }
            ++i;
        }
        if (item != null && JavaScriptCompletionEngine2.exists(item)) {
            this.reportItems(reporter, item);
        }
    }

    protected void reportItems(Reporter reporter, IValueParent item) {
        reporter.report(item);
        if (item instanceof IValueCollection) {
            IValueCollection coll = (IValueCollection)item;
            while ((coll = coll.getParent()) != null) {
                reporter.report(coll);
            }
        } else if (item instanceof IValueReference) {
            reporter.reportValueTypeMembers((IValueReference)item);
        }
    }

    protected void reportGlobals(Reporter reporter) {
        ITypeInferenceContext context = reporter.context;
        Set<String> globals = context.listGlobals(reporter.getPrefix());
        for (String global : globals) {
            Type type;
            if (reporter.canReport(global)) {
                IRMember element = context.resolve(global);
                if (element == null || !element.isVisible()) continue;
                reporter.report(global, element);
                continue;
            }
            if (global.lastIndexOf(46) == -1 || (type = context.getType(global)) == null || !type.isVisible() || type.getKind() == TypeKind.UNKNOWN) continue;
            reporter.reportTypeRef(type);
        }
    }

    void doGlobalCompletion(IValueCollection collection, Reporter reporter, JavaScriptCompletionUtil.ExpressionContext expressionContext) {
        if (expressionContext != null && expressionContext.expressionType == JavaScriptCompletionUtil.ExpressionType.OBJECT_INITIALIZER) {
            return;
        }
        this.reportItems(reporter, collection);
        if ((this.globalOptions & 1) != 0) {
            if (!this.requestor.isIgnored(7)) {
                this.doCompletionOnType(TypeMode.CODE, reporter);
            }
            this.reportGlobals(reporter);
        }
        if ((this.globalOptions & 2) != 0 && !this.requestor.isIgnored(2)) {
            this.doCompletionOnKeyword(reporter.getPrefix(), reporter.getPosition(), expressionContext);
        }
    }

    private void doCompletionOnKeyword(String prefix, int position, JavaScriptCompletionUtil.ExpressionContext expressionContext) {
        String[] keywords = expressionContext != null ? (expressionContext.expressionType == JavaScriptCompletionUtil.ExpressionType.PROPERTY_INITIALIZER_VALUE ? JavaScriptKeywords.getJavaScriptValueKeywords() : JavaScriptKeywords.getJavaScriptExpressionKeywords()) : JavaScriptKeywords.getJavaScriptKeywords();
        this.findKeywords(prefix.toCharArray(), keywords, true);
    }

    private class Reporter {
        final ITypeInferenceContext context;
        final char[] prefix;
        private final String prefixStr;
        final int position;
        final Set<String> processed = new HashSet<String>();
        final boolean camelCase = "enabled".equals(DLTKCore.getOption((String)"org.eclipse.dltk.core.codeComplete.camelCaseMatch"));
        final boolean visibilityCheck = "enabled".equals(Platform.getPreferencesService().getString("org.eclipse.dltk.javascript.core", "org.eclipse.dltk.core.codeComplete.visibilityCheck", null, null));
        final IValidatorExtension[] extensions;
        private MemberValidationEvent memberValidationEvent;

        public Reporter(ITypeInferenceContext context, String prefix, int position, List<IValidatorExtension> extensions) {
            this.context = context;
            this.prefixStr = prefix != null ? prefix : "";
            this.prefix = this.prefixStr.toCharArray();
            this.position = position;
            this.extensions = !extensions.isEmpty() ? extensions.toArray(new IValidatorExtension[extensions.size()]) : null;
        }

        public void ignore(String generatedIdentifier) {
            this.processed.add(generatedIdentifier);
        }

        public String getPrefix() {
            return this.prefixStr;
        }

        public int getPosition() {
            return this.position;
        }

        public void report(String name, IRElement element) {
            if (element instanceof IRMember && this.processed.add(name)) {
                this.reportMember((IRMember)element, name, false);
            }
        }

        public boolean canReport(String name) {
            return this.matches(name) && !this.processed.contains(name);
        }

        boolean matches(String name) {
            return CharOperation.prefixEquals((char[])this.prefix, (String)name, (boolean)false) || this.camelCase && CharOperation.camelCaseMatch((char[])this.prefix, (char[])name.toCharArray());
        }

        public void report(IValueParent item) {
            Set<String> deleted = item.getDeletedChildren();
            block0: for (String childName : item.getDirectChildren()) {
                IValueReference child;
                if (childName.equals("()") || deleted.contains(childName) || !this.matches(childName) || !this.processed.add(childName) || !(child = item.getChild(childName)).exists()) continue;
                if (this.visibilityCheck && this.extensions != null) {
                    if (this.memberValidationEvent == null) {
                        this.memberValidationEvent = new MemberValidationEvent();
                    }
                    this.memberValidationEvent.set(child, null);
                    IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                    int n = this.extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IValidatorExtension extension = iValidatorExtensionArray[n2];
                        IValidationStatus status = extension.validateAccessibility(this.memberValidationEvent);
                        if (status != null) {
                            if (status != ValidationStatus.OK) continue block0;
                            break;
                        }
                        ++n2;
                    }
                }
                this.reportReference(child);
            }
        }

        public void reportValueTypeMembers(IValueReference valueRef) {
            RTypeMemberQuery typeQuery = new RTypeMemberQuery();
            HashSet<IRMember> members = new HashSet<IRMember>();
            this.collectTypes(valueRef.getDeclaredTypes(), typeQuery, members, valueRef);
            this.collectTypes(valueRef.getTypes(), typeQuery, members, valueRef);
            for (IRMember member : members) {
                if (!member.isVisible() || !this.matches(member.getName())) continue;
                this.reportMember(member, member.getName(), true);
            }
            for (IRMember member : typeQuery.ignoreDuplicates(this.processed)) {
                if (!member.isVisible() || !this.matches(member.getName())) continue;
                this.reportMember(member, member.getName(), typeQuery.contains(member.getDeclaringType()));
            }
        }

        protected void collectTypes(JSTypeSet types, RTypeMemberQuery typeQuery, Collection<IRMember> members, IValueReference valueRef) {
            for (IRType type : types) {
                IRTypeDeclaration t;
                if (type instanceof IRClassType) {
                    t = ((IRClassType)type).getDeclaration();
                    if (t != null) {
                        MemberPredicate predicate = t.getSource().memberPredicateFor(type, MemberPredicates.STATIC);
                        typeQuery.add(t, predicate);
                        if (!t.getSource().hasPrototype() || !predicate.isCompatibleWith(MemberPredicates.STATIC)) continue;
                        Type prototypeType = t.getSource().getPrototypeType();
                        if (prototypeType == Types.FUNCTION && !this.canInstantiate(t.getSource(), valueRef)) {
                            prototypeType = Types.OBJECT;
                        }
                        typeQuery.add(this.context.convert(prototypeType), MemberPredicates.NON_STATIC);
                        continue;
                    }
                    typeQuery.add(RTypes.FUNCTION.getDeclaration(), MemberPredicates.NON_STATIC);
                    continue;
                }
                if (type instanceof IRSimpleType) {
                    t = ((IRSimpleType)type).getDeclaration();
                    typeQuery.add(t, t.getSource().memberPredicateFor(type, MemberPredicates.NON_STATIC));
                    continue;
                }
                if (type instanceof IRRecordType) {
                    members.addAll(((IRRecordType)type).getMembers());
                    typeQuery.add(RTypes.OBJECT.getDeclaration(), MemberPredicates.NON_STATIC);
                    continue;
                }
                if (type instanceof IRFunctionType) {
                    IRFunctionType functionType = (IRFunctionType)type;
                    members.add(FunctionMethod.apply.create(functionType));
                    members.add(FunctionMethod.call.create(functionType));
                    typeQuery.add(RTypes.FUNCTION.getDeclaration(), new MemberPredicate(){

                        @Override
                        public boolean isCompatibleWith(MemberPredicate predicate) {
                            return MemberPredicates.NON_STATIC == predicate;
                        }

                        @Override
                        public boolean evaluate(Member member) {
                            return MemberPredicates.NON_STATIC.evaluate(member) && !FunctionMethod.apply.test(member.getName()) && !FunctionMethod.call.test(member.getName());
                        }

                        @Override
                        public boolean evaluate(IRMember member) {
                            return member.getSource() instanceof Member && this.evaluate((Member)member.getSource());
                        }
                    });
                    continue;
                }
                if (!type.isJavaScriptObject()) continue;
                typeQuery.add(RTypes.OBJECT.getDeclaration(), MemberPredicates.NON_STATIC);
            }
        }

        private boolean canInstantiate(Type type, IValueReference ref) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus status = extension.canInstantiate(type, ref);
                    if (status != null && status != ValidationStatus.OK) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void reportMember(IRMember member, String memberName, boolean important) {
            if (this.visibilityCheck && this.extensions != null && member.getSource() instanceof Member) {
                Member source = (Member)member.getSource();
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus status = extension.validateAccessibility(source);
                    if (status != null) {
                        if (status == ValidationStatus.OK) break;
                        return;
                    }
                    ++n2;
                }
            }
            boolean isFunction = member instanceof IRMethod || member instanceof IRRecordMember && member.getType() instanceof IRFunctionType;
            CompletionProposal proposal = CompletionProposal.create((int)(isFunction ? 5 : 1), (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, memberName);
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(isFunction ? String.valueOf(memberName) + "()" : memberName);
            proposal.setName(memberName);
            proposal.setExtraInfo(member.getSource());
            if (isFunction) {
                List<IRParameter> parameters = null;
                parameters = member.getType() instanceof IRFunctionType ? ((IRFunctionType)member.getType()).getParameters() : ((IRMethod)member).getParameters();
                int paramCount = parameters.size();
                if (paramCount > 0) {
                    String[] params = new String[paramCount];
                    int i = 0;
                    while (i < paramCount) {
                        params[i] = parameters.get(i).getName();
                        if (params[i] == null && parameters.get(i).getType() != null) {
                            params[i] = parameters.get(i).getType().getName();
                        }
                        if (params[i] == null) {
                            params[i] = "anon_" + i;
                        }
                        ++i;
                    }
                    proposal.setParameterNames(params);
                    if (parameters.get(paramCount - 1).getKind() != ParameterKind.NORMAL) {
                        int requiredCount = parameters.size();
                        while (requiredCount > 0 && parameters.get(requiredCount - 1).getKind() != ParameterKind.NORMAL) {
                            --requiredCount;
                        }
                        if (requiredCount == 0 && parameters.get(requiredCount).getKind() == ParameterKind.VARARGS) {
                            ++requiredCount;
                        }
                        if (requiredCount != paramCount) {
                            proposal.setAttribute("org.eclipse.dltk.core.MethodCompletionProposal#ParameterLimit", (Object)requiredCount);
                        }
                    }
                }
            }
            JavaScriptCompletionEngine2.this.accept(proposal);
        }

        private void reportReference(IValueReference reference) {
            Object element = reference.getAttribute("ELEMENT");
            if (element instanceof IRMember) {
                this.reportMember((IRMember)element, ((IRMember)element).getName(), true);
            } else {
                int paramCount;
                IRMethod method;
                int proposalKind = 1;
                ReferenceKind kind = reference.getKind();
                if (reference.getAttribute("PHANTOM", true) == null && (kind == ReferenceKind.FUNCTION || reference.hasChild("()"))) {
                    proposalKind = 5;
                } else if (kind == ReferenceKind.LOCAL) {
                    proposalKind = 4;
                }
                CompletionProposal proposal = CompletionProposal.create((int)proposalKind, (int)this.position);
                int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
                relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
                relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, reference.getName());
                proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
                proposal.setCompletion(proposalKind == 5 ? String.valueOf(reference.getName()) + "()" : reference.getName());
                proposal.setName(reference.getName());
                proposal.setExtraInfo((Object)reference);
                if (proposalKind == 5 && (method = (IRMethod)reference.getAttribute("R_METHOD", true)) != null && (paramCount = method.getParameterCount()) > 0) {
                    String[] params = new String[paramCount];
                    int i = 0;
                    while (i < paramCount) {
                        params[i] = method.getParameters().get(i).getName();
                        ++i;
                    }
                    proposal.setParameterNames(params);
                    if (method.getParameters().get(paramCount - 1).getKind() != ParameterKind.NORMAL) {
                        int requiredCount = method.getParameters().size();
                        while (requiredCount > 0 && method.getParameters().get(requiredCount - 1).getKind() != ParameterKind.NORMAL) {
                            --requiredCount;
                        }
                        if (requiredCount == 0 && method.getParameters().get(requiredCount).getKind() == ParameterKind.VARARGS) {
                            ++requiredCount;
                        }
                        if (requiredCount != paramCount) {
                            proposal.setAttribute("org.eclipse.dltk.core.MethodCompletionProposal#ParameterLimit", (Object)requiredCount);
                        }
                    }
                }
                JavaScriptCompletionEngine2.this.accept(proposal);
            }
        }

        public void reportTypeRef(Type type) {
            if (!this.processed.add(type.getName())) {
                return;
            }
            CompletionProposal proposal = CompletionProposal.create((int)7, (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, type.getName());
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(type.getName());
            proposal.setName(type.getName());
            proposal.setExtraInfo((Object)type);
            JavaScriptCompletionEngine2.this.accept(proposal);
        }
    }
}

