/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;

class RMapType
extends RType
implements IRMapType {
    private final IRType valueType;
    private final IRType keyType;

    public RMapType(IRType keyType, IRType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public String getName() {
        if (this.valueType != null && this.keyType != null && !"String".equals(this.keyType.getName())) {
            return "Object<" + this.keyType.getName() + ',' + this.valueType.getName() + '>';
        }
        return this.valueType != null ? "Object<" + this.valueType.getName() + '>' : "Object";
    }

    public int hashCode() {
        return this.valueType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RMapType) {
            RMapType other = (RMapType)obj;
            return this.valueType.equals(other.valueType);
        }
        return false;
    }

    @Override
    public boolean isExtensible() {
        return true;
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof RMapType) {
            return this.valueType.isAssignableFrom(((RMapType)type).valueType);
        }
        if (type instanceof IRRecordType) {
            TypeCompatibility result = TypeCompatibility.TRUE;
            for (IRRecordMember member : ((IRRecordType)type).getMembers()) {
                TypeCompatibility compatibility = this.valueType.isAssignableFrom(member.getType());
                if (compatibility == TypeCompatibility.FALSE) {
                    return compatibility;
                }
                if (compatibility == result || !compatibility.after(result)) continue;
                result = compatibility;
            }
            return result;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public IRType getKeyType() {
        return this.keyType;
    }

    @Override
    public IRType getValueType() {
        return this.valueType;
    }
}

