/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.SearcherManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.index.lucene.LucenePlugin;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.index.lucene.IndexContainer;
import org.eclipse.dltk.internal.core.index.lucene.IndexProperties;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.search.DLTKWorkspaceScope;
import org.osgi.framework.Bundle;

public enum LuceneManager {
    INSTANCE;

    private static final String INDEX_DIR = "index";
    private static final String PROPERTIES_FILE = ".properties";
    private static final String MAPPINGS_FILE = ".mappings";
    private final String fIndexRoot;
    private final Properties fIndexProperties = new Properties();
    private final Properties fContainerMappings = new Properties();
    private final Map<String, IndexContainer> fIndexContainers = new HashMap<String, IndexContainer>();

    private LuceneManager() {
        this.fIndexRoot = Platform.getStateLocation((Bundle)LucenePlugin.getDefault().getBundle()).append(INDEX_DIR).toOSString();
        File indexRootDirectory = new File(this.fIndexRoot);
        if (!indexRootDirectory.exists()) {
            indexRootDirectory.mkdirs();
        }
        this.startup();
    }

    public final IndexWriter findIndexWriter(String container, IndexType dataType, int elementType) {
        return this.getIndexContainer(container).getIndexWriter(dataType, elementType);
    }

    public final SearcherManager findIndexSearcher(String container, IndexType dataType, int elementType) {
        return this.getIndexContainer(container).getIndexSearcher(dataType, elementType);
    }

    public final IndexWriter findTimestampsWriter(String container) {
        return this.getIndexContainer(container).getTimestampsWriter();
    }

    public final SearcherManager findTimestampsSearcher(String container) {
        return this.getIndexContainer(container).getTimestampsSearcher();
    }

    public final void delete(String container) {
        this.deleteIndexContainer(container);
    }

    public final void delete(String container, String sourceModule) {
        if (this.fContainerMappings.getProperty(container) != null) {
            this.getIndexContainer(container).delete(sourceModule);
        }
    }

    private synchronized void startup() {
        this.loadProperties();
        boolean purgeIndexRoot = false;
        boolean resetProperties = false;
        String modelVersion = this.fIndexProperties.getProperty("org.eclipse.dltk.core.index.lucene.property.model.version");
        String luceneVersion = this.fIndexProperties.getProperty("org.eclipse.dltk.core.index.lucene.property.lucene.version");
        if (!"1.0".equals(modelVersion) || !IndexProperties.LUCENE_VERSION.equals(luceneVersion)) {
            purgeIndexRoot = true;
            resetProperties = true;
        }
        if (purgeIndexRoot) {
            this.purge();
        }
        if (resetProperties) {
            this.resetProperties();
            this.saveProperties();
        }
        this.loadMappings();
        this.registerIndexContainers();
        ModelManager.getModelManager().getIndexManager().addShutdownListener((IShutdownListener)new ShutdownListener());
    }

    private synchronized void shutdown() {
        for (IndexContainer entry : this.fIndexContainers.values()) {
            entry.close();
        }
        this.cleanup();
    }

    private synchronized IndexContainer getIndexContainer(String container) {
        String containerId = this.fContainerMappings.getProperty(container);
        if (containerId == null) {
            while (this.fContainerMappings.containsValue(containerId = UUID.randomUUID().toString())) {
            }
            this.fContainerMappings.put(container, containerId);
            this.fIndexContainers.put(containerId, new IndexContainer(this.fIndexRoot, containerId));
            this.saveMappings();
        }
        return this.fIndexContainers.get(containerId);
    }

    private synchronized void deleteIndexContainer(String container) {
        String containerId = (String)this.fContainerMappings.remove(container);
        if (containerId != null) {
            IndexContainer containerEntry = this.fIndexContainers.remove(containerId);
            this.saveMappings();
            containerEntry.delete();
        }
    }

    private void registerIndexContainers() {
        for (String container : this.fContainerMappings.stringPropertyNames()) {
            String containerId = this.fContainerMappings.getProperty(container);
            this.fIndexContainers.put(containerId, new IndexContainer(this.fIndexRoot, containerId));
        }
    }

    private void loadProperties() {
        File file = Paths.get(this.fIndexRoot, PROPERTIES_FILE).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                this.fIndexProperties.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void loadMappings() {
        File file = Paths.get(this.fIndexRoot, MAPPINGS_FILE).toFile();
        if (!file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                this.fContainerMappings.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void saveProperties() {
        File file = Paths.get(this.fIndexRoot, PROPERTIES_FILE).toFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                this.fIndexProperties.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void saveMappings() {
        File file = Paths.get(this.fIndexRoot, MAPPINGS_FILE).toFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                this.fContainerMappings.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private void resetProperties() {
        this.fIndexProperties.clear();
        this.fIndexProperties.put("org.eclipse.dltk.core.index.lucene.property.model.version", "1.0");
        this.fIndexProperties.put("org.eclipse.dltk.core.index.lucene.property.lucene.version", IndexProperties.LUCENE_VERSION);
    }

    private void cleanup() {
        ArrayList<String> containers = new ArrayList<String>();
        IDLTKLanguageToolkit[] iDLTKLanguageToolkitArray = DLTKLanguageManager.getLanguageToolkits();
        int n = iDLTKLanguageToolkitArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDLTKLanguageToolkit toolkit = iDLTKLanguageToolkitArray[n2];
            DLTKWorkspaceScope scope = ModelManager.getModelManager().getWorkspaceScope(toolkit);
            IPath[] iPathArray = scope.enclosingProjectsAndZips();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                containers.add(path.toString());
                ++n4;
            }
            ++n2;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String mappedContainer : this.fContainerMappings.stringPropertyNames()) {
            if (containers.contains(mappedContainer)) continue;
            toRemove.add(mappedContainer);
        }
        if (!toRemove.isEmpty()) {
            for (String container : toRemove) {
                this.deleteIndexContainer(container);
            }
            this.saveMappings();
        }
    }

    private void purge() {
        Path indexRoot = Paths.get(this.fIndexRoot, new String[0]);
        try {
            Files.walkFileTree(indexRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        indexRoot.toFile().mkdir();
    }

    private static final class ShutdownListener
    implements IShutdownListener {
        private ShutdownListener() {
        }

        public void shutdown() {
            INSTANCE.shutdown();
        }
    }
}

