/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.DLTKFeatures;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ZipArchiveFile;

public abstract class AbstractLanguageToolkit
implements IDLTKLanguageToolkit {
    @Override
    public boolean languageSupportZIPBuildpath() {
        return false;
    }

    @Override
    public boolean validateSourcePackage(IPath path, IEnvironment environment) {
        return true;
    }

    @Override
    public IStatus validateSourceModule(IResource resource) {
        return Status.OK_STATUS;
    }

    protected static boolean isEmptyExtension(String name) {
        return name.indexOf(46) == -1;
    }

    @Override
    public boolean canValidateContent(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment(project);
        if (environment == null || !environment.isLocal()) {
            return false;
        }
        return AbstractLanguageToolkit.isEmptyExtension(resource.getName());
    }

    @Override
    public boolean canValidateContent(File file) {
        return AbstractLanguageToolkit.isEmptyExtension(file.getName());
    }

    @Override
    public boolean canValidateContent(IFileHandle file) {
        return false;
    }

    @Override
    public String getPreferenceQualifier() {
        return null;
    }

    @Override
    public boolean get(DLTKFeatures.BooleanFeature feature) {
        return feature.getDefaultValue();
    }

    @Override
    public int get(DLTKFeatures.IntegerFeature feature) {
        return feature.getDefaultValue();
    }

    @Override
    public String get(DLTKFeatures.StringFeature feature) {
        return feature.getDefaultValue();
    }

    @Override
    public IArchive openArchive(File localFile) throws IOException {
        return new ZipArchiveFile(localFile);
    }

    @Override
    public String getFileType() {
        String[] specs;
        IContentType contentType = Platform.getContentTypeManager().getContentType(this.getLanguageContentType());
        if (contentType != null && (specs = contentType.getFileSpecs(10)).length != 0) {
            return specs[0];
        }
        return "txt";
    }
}

