/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclInterpreterInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.AddTclInterpreterDialog;
import org.eclipse.dltk.tcl.internal.ui.TclImages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class AvailablePackagesBlock {
    private TclInterpreterInfo interpreter = null;
    private TreeViewer viewer;
    private AddTclInterpreterDialog dialog;

    public AvailablePackagesBlock(AddTclInterpreterDialog dialog) {
        this.dialog = dialog;
    }

    public void createIn(Composite content) {
        this.viewer = new TreeViewer(content);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = 50;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            final ImageDescriptorRegistry registry = new ImageDescriptorRegistry(false);

            public String getText(Object element) {
                if (element instanceof TclPackageInfo) {
                    String name = ((TclPackageInfo)element).getName();
                    String version = ((TclPackageInfo)element).getVersion();
                    if (version != null && version.length() > 0) {
                        return String.valueOf(name) + " (" + version + ")";
                    }
                    return name;
                }
                if (element instanceof Node) {
                    return ((Node)element).value;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof TclPackageInfo) {
                    return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.package_obj.png");
                }
                if (element instanceof Node) {
                    Object image = ((Node)element).image;
                    if (image instanceof Image) {
                        return (Image)image;
                    }
                    if (image instanceof ImageDescriptor) {
                        return this.registry.get((ImageDescriptor)image);
                    }
                }
                return this.registry.get(TclImages.DESC_OBJS_TCL);
            }

            public void dispose() {
                super.dispose();
                this.registry.dispose();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof TclInterpreterInfo) {
                    TclInterpreterInfo info = (TclInterpreterInfo)inputElement;
                    EList packages = info.getPackages();
                    ArrayList sorted = new ArrayList();
                    sorted.addAll(packages);
                    Collections.sort(sorted, new Comparator<TclPackageInfo>(){

                        @Override
                        public int compare(TclPackageInfo o1, TclPackageInfo o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    return sorted.toArray();
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return element instanceof TclPackageInfo;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TclPackageInfo) {
                    TclPackageInfo info = (TclPackageInfo)parentElement;
                    if (!info.isFetched()) {
                        TclPackagesManager.getPackageInfo((InterpreterStandin)AvailablePackagesBlock.this.dialog.getInterpreterStandin(), (String)info.getName(), (boolean)true, (TclInterpreterInfo)AvailablePackagesBlock.this.interpreter, null);
                    }
                    ArrayList<Node> result = new ArrayList<Node>();
                    EList sources = info.getSources();
                    for (String source : sources) {
                        Node nde = new Node(null, null);
                        nde.value = source;
                        nde.image = TclImages.DESC_OBJS_TCL;
                        result.add(nde);
                    }
                    EList libs = info.getLibraries();
                    for (String source : libs) {
                        Library nde = new Library();
                        nde.value = source;
                        nde.image = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_obj.png");
                        result.add(nde);
                    }
                    return result.toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof Library) {
                    return 1;
                }
                return super.category(element);
            }
        });
    }

    public void updatePackages(TclInterpreterInfo info) {
        this.interpreter = info;
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AvailablePackagesBlock.this.viewer.setInput((Object)AvailablePackagesBlock.this.interpreter);
                AvailablePackagesBlock.this.viewer.refresh();
            }
        });
    }

    private static class Library
    extends Node {
        private Library() {
        }
    }

    private static class Node {
        String value;
        Object image;

        private Node() {
        }

        /* synthetic */ Node(Node node, Node node2) {
            this();
        }
    }
}

