/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.callhierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestorAdaptor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.MethodSourceCode;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;

public class RubyCalleeProcessor
implements ICalleeProcessor {
    protected static int EXACT_RULE = 8;
    private Map<SimpleReference, IMethod[]> fSearchResults = new HashMap<SimpleReference, IMethod[]>();
    private IMethod method;

    public RubyCalleeProcessor(IMethod method, IProgressMonitor monitor, IDLTKSearchScope scope) {
        this.method = method;
    }

    public Map<SimpleReference, IMethod[]> doOperation() {
        CaleeSourceElementRequestor requestor = new CaleeSourceElementRequestor();
        ISourceElementParser parser = null;
        parser = DLTKLanguageManager.getSourceElementParser((String)"org.eclipse.dltk.ruby.core.nature");
        parser.setRequestor((ISourceElementRequestor)requestor);
        parser.parseSourceModule((IModuleSource)new MethodSourceCode(this.method));
        return this.fSearchResults;
    }

    public IMethod[] findMethods(String methodName, int argCount, int sourcePosition) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        ISourceModule module = this.method.getSourceModule();
        try {
            IModelElement[] elements = module.codeSelect(sourcePosition, 1);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IMethod) {
                    methods.add((IMethod)elements[i]);
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private class CaleeSourceElementRequestor
    extends SourceElementRequestorAdaptor {
        private CaleeSourceElementRequestor() {
        }

        public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
            int off = 0;
            try {
                off = RubyCalleeProcessor.this.method.getSourceRange().getOffset();
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            SimpleReference ref = new SimpleReference(off + sourcePosition, off + sourceEndPosition, methodName);
            IMethod[] methods = RubyCalleeProcessor.this.findMethods(methodName, argCount, off + sourceEndPosition - 1);
            RubyCalleeProcessor.this.fSearchResults.put(ref, methods);
        }
    }
}

