/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.text;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.sh.internal.ui.Activator;
import org.eclipse.dltk.sh.internal.ui.text.AssignmentDetector;
import org.eclipse.dltk.sh.internal.ui.text.AssignmentRule;
import org.eclipse.dltk.sh.internal.ui.text.DollarDetector;
import org.eclipse.dltk.sh.internal.ui.text.DollarRule;
import org.eclipse.dltk.sh.internal.ui.text.WhitespaceDetector;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class ShellCodeScanner
extends AbstractScriptScanner {
    public static final String[] KEYWORDS = new String[]{"do", "done", "if", "fi", "then", "else", "elif", "case", "esac", "while", "for", "in", "select", "time", "until", "function", "[", "[[", "]", "]]", "set", "unset", "declare", "export", "source", "pushd", "popd", "exit"};
    private static List<String> fgCommands = ShellCodeScanner.getCommands();
    private static String[] fgTokenProperties = new String[]{"DLTK_default", "DLTK_keyword", "DLTK_argument", "DLTK_base_class"};

    public ShellCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    public static List<String> getCommands() {
        String[] pathEntries;
        String path = System.getenv("PATH");
        ArrayList<String> commands = new ArrayList<String>();
        String[] stringArray = pathEntries = path.split(System.getProperty("path.separator"));
        int n = pathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String pathEntry = stringArray[n2];
            File dir = new File(pathEntry);
            if (dir.exists() && dir.isDirectory()) {
                File[] files = dir.listFiles();
                if (files == null) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dltk.sh.ui", "listFiles() returned null: " + dir));
                    files = new File[]{};
                }
                File[] fileArray = files;
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    if (file.canExecute()) {
                        if (file.getName().endsWith(".exe")) {
                            commands.add(file.getName().substring(0, file.getName().length() - 4));
                        } else {
                            commands.add(file.getName());
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return commands;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token keyword = this.getToken("DLTK_keyword");
        Token commandToken = this.getToken("DLTK_base_class");
        Token other = this.getToken("DLTK_default");
        Token variable = this.getToken("DLTK_argument");
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new AssignmentRule(new AssignmentDetector(), Token.UNDEFINED, (IToken)variable));
        rules.add(new DollarRule(new DollarDetector(), Token.UNDEFINED, (IToken)variable));
        WordRule wordRule = new WordRule((IWordDetector)new ShellWordDetector(), (IToken)other);
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            wordRule.addWord(element, (IToken)keyword);
            ++n2;
        }
        for (String command : fgCommands) {
            wordRule.addWord(command, (IToken)commandToken);
        }
        rules.add((IRule)wordRule);
        return rules;
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    public static class ShellWordDetector
    implements IWordDetector {
        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character) && character != '$' || character == '-' || character == '.';
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character) && character != '$';
        }
    }
}

