/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;
import org.eclipse.dltk.javascript.ui.typeinfo.ElementLabelProviderRegistry;
import org.eclipse.dltk.javascript.ui.typeinfo.IElementLabelProvider;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class JavaScriptCompletionProposalLabelProvider
extends CompletionProposalLabelProvider {
    public String createTypeProposalLabel(CompletionProposal typeProposal) {
        if (typeProposal.getExtraInfo() instanceof Type) {
            Type type = (Type)typeProposal.getExtraInfo();
            String label = JavaScriptCompletionProposalLabelProvider.getElementLabel((Element)type, typeProposal);
            if (label != null) {
                return label;
            }
            if (type instanceof GenericType) {
                StringBuilder sb = new StringBuilder();
                sb.append(type.getName()).append('<');
                boolean first = true;
                for (TypeVariable variable : ((GenericType)type).getTypeParameters()) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(variable.getName());
                    first = false;
                }
                sb.append('>');
                return sb.toString();
            }
        }
        return super.createTypeProposalLabel(typeProposal);
    }

    private static String getElementLabel(Element element, CompletionProposal proposal) {
        return ElementLabelProviderRegistry.getLabel(element, IElementLabelProvider.Mode.PROPOSAL, proposal);
    }

    protected String createMethodProposalLabel(CompletionProposal methodProposal) {
        String returnType = null;
        String source = null;
        Object info = methodProposal.getExtraInfo();
        if (info instanceof Method) {
            Method method = (Method)info;
            String label = JavaScriptCompletionProposalLabelProvider.getElementLabel((Element)method, methodProposal);
            if (label != null) {
                return label;
            }
            if (method.getType() != null) {
                returnType = method.getType().getName();
            }
            if (method.getDeclaringType() != null) {
                source = method.getDeclaringType().getName();
            }
        } else if (info instanceof IValueReference) {
            ReferenceLocation loc;
            IValueReference reference = (IValueReference)info;
            IRType declaredType = reference.getChild("()").getDeclaredType();
            if (declaredType != null) {
                returnType = declaredType.getName();
            }
            if ((loc = reference.getLocation()) != ReferenceLocation.UNKNOWN && loc.getSourceModule() != null) {
                source = loc.getSourceModule().getPath().toString();
            }
        }
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        if (returnType != null) {
            nameBuffer.append(": ");
            nameBuffer.append(returnType);
        }
        if (source != null) {
            nameBuffer.append(" - ");
            nameBuffer.append(source);
        }
        return nameBuffer.toString();
    }

    protected String createFieldProposalLabel(CompletionProposal proposal) {
        Object info = proposal.getExtraInfo();
        if (info instanceof Property) {
            Property property = (Property)proposal.getExtraInfo();
            String label = JavaScriptCompletionProposalLabelProvider.getElementLabel((Element)property, proposal);
            if (label != null) {
                return label;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(proposal.getName());
            if (TypeUtil.isValueTypeVisible((JSType)property.getType())) {
                sb.append(": ");
                sb.append(property.getType().getName());
            }
            if (TypeUtil.isDeclaringTypeVisible((Member)property)) {
                sb.append(" - ");
                sb.append(property.getDeclaringType().getName());
            }
            return sb.toString();
        }
        if (proposal.getExtraInfo() instanceof IValueReference) {
            IRType declaredType;
            IValueReference reference = (IValueReference)proposal.getExtraInfo();
            StringBuilder sb = new StringBuilder();
            sb.append(proposal.getName());
            if (reference.getKind() != ReferenceKind.PREDEFINED && (declaredType = reference.getDeclaredType()) != null) {
                sb.append(": ").append(declaredType.getName());
            }
            return sb.toString();
        }
        return proposal.getName();
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createImageDescriptor(proposal);
    }

    private ImageDescriptor extraImageFromProposal(CompletionProposal proposal) {
        Object extraInfo = proposal.getExtraInfo();
        if (extraInfo instanceof Element) {
            Element element = (Element)extraInfo;
            ImageDescriptor descriptor = ElementLabelProviderRegistry.getImageDescriptor(element);
            if (descriptor != null) {
                return this.decorateImageDescriptor(descriptor, proposal);
            }
            if (element instanceof Member) {
                int flags = ((Member)element).getVisibility().getFlags();
                if (element instanceof Property) {
                    return this.decorateImageDescriptor(ScriptElementImageProvider.getFieldImageDescriptor((int)flags), proposal);
                }
                if (element instanceof Method) {
                    return this.decorateImageDescriptor(ScriptElementImageProvider.getMethodImageDescriptor((int)flags), proposal);
                }
            }
        } else if (extraInfo instanceof IValueReference) {
            IValueReference reference = (IValueReference)extraInfo;
            IModelBuilder.IMethod method = (IModelBuilder.IMethod)reference.getAttribute("METHOD");
            if (method != null) {
                return this.decorateImageDescriptor(ScriptElementImageProvider.getMethodImageDescriptor((int)Visibility.getFlags((Visibility)method.getVisibility())), proposal);
            }
            IModelBuilder.IVariable variable = (IModelBuilder.IVariable)reference.getAttribute("VARIABLE");
            if (variable != null) {
                return this.decorateImageDescriptor(ScriptElementImageProvider.getFieldImageDescriptor((int)Visibility.getFlags((Visibility)variable.getVisibility())), proposal);
            }
        }
        return null;
    }

    protected ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createFieldImageDescriptor(proposal);
    }

    protected ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createLocalImageDescriptor(proposal);
    }

    public ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createMethodImageDescriptor(proposal);
    }

    protected ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createPackageImageDescriptor(proposal);
    }

    public ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor imageDescriptor = this.extraImageFromProposal(proposal);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return super.createTypeImageDescriptor(proposal);
    }

    protected ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        if (this.isDeprecated(proposal)) {
            return new ScriptElementImageDescriptor(descriptor, 1024, ScriptElementImageProvider.SMALL_SIZE);
        }
        if (this.isStatic(proposal)) {
            return new ScriptElementImageDescriptor(descriptor, 8, ScriptElementImageProvider.SMALL_SIZE);
        }
        return super.decorateImageDescriptor(descriptor, proposal);
    }

    private boolean isStatic(CompletionProposal proposal) {
        if (proposal.getExtraInfo() instanceof Member) {
            return ((Member)proposal.getExtraInfo()).isStatic();
        }
        return false;
    }

    private boolean isDeprecated(CompletionProposal proposal) {
        if (proposal.getExtraInfo() instanceof Element) {
            return ((Element)proposal.getExtraInfo()).isDeprecated();
        }
        if (proposal.getExtraInfo() instanceof IValueReference) {
            IValueReference reference = (IValueReference)proposal.getExtraInfo();
            IModelBuilder.IMethod method = (IModelBuilder.IMethod)reference.getAttribute("METHOD");
            if (method != null) {
                return method.isDeprecated();
            }
            IModelBuilder.IVariable variable = (IModelBuilder.IVariable)reference.getAttribute("VARIABLE");
            return variable != null && variable.isDeprecated();
        }
        if (proposal.getExtraInfo() instanceof JSMethod) {
            return ((JSMethod)proposal.getExtraInfo()).isDeprecated();
        }
        return false;
    }
}

