/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsoleServer;
import org.eclipse.dltk.console.ScriptInterpreterManager;
import org.eclipse.dltk.console.ui.IScriptConsole;
import org.eclipse.dltk.console.ui.IScriptConsoleFactory;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.internal.ConsoleViewManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.launching.process.IScriptProcess;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class ScriptConsoleManager
implements ILaunchListener {
    private static ScriptConsoleManager instance;
    private String[] consoleViewIds = null;

    public static synchronized ScriptConsoleManager getInstance() {
        if (instance == null) {
            instance = new ScriptConsoleManager();
        }
        return instance;
    }

    private IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }

    public IScriptConsole[] getScriptConsoles(String consoleType) {
        ArrayList<ScriptConsole> consoles = new ArrayList<ScriptConsole>();
        IConsole[] iConsoleArray = this.getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof IScriptConsole && console.getType().equals(consoleType)) {
                consoles.add((ScriptConsole)console);
            }
            ++n2;
        }
        return consoles.toArray(new IScriptConsole[consoles.size()]);
    }

    private synchronized String[] getConsoleViewIds() {
        if (this.consoleViewIds == null) {
            ArrayList<String> viewIds = new ArrayList<String>();
            ConsoleViewManager.Descriptor[] descriptorArray = new ConsoleViewManager("org.eclipse.dltk.console.ui.consoleView").getDescriptors();
            int n = descriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleViewManager.Descriptor descriptor = descriptorArray[n2];
                viewIds.add(descriptor.getViewId());
                ++n2;
            }
            this.consoleViewIds = viewIds.toArray(new String[viewIds.size()]);
        }
        return this.consoleViewIds;
    }

    public IScriptConsole getActiveScriptConsole(String consoleType) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            String[] stringArray = this.getConsoleViewIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsoleView view;
                IConsole console;
                String consoleViewId = stringArray[n2];
                IViewPart part = page.findView(consoleViewId);
                if (part != null && part instanceof IConsoleView && (console = (view = (IConsoleView)part).getConsole()) instanceof IScriptConsole && console.getType().equals(consoleType)) {
                    return (IScriptConsole)console;
                }
                ++n2;
            }
        }
        return null;
    }

    public void close(IScriptConsole console) {
        console.terminate();
        this.remove(console);
    }

    public void closeAll() {
        IConsole[] consoles = this.getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console instanceof IScriptConsole) {
                this.close((IScriptConsole)console);
            }
            ++i;
        }
    }

    public void showConsole(IScriptConsole console) {
        this.getConsoleManager().showConsoleView((IConsole)console);
    }

    public void add(IScriptConsole console) {
        this.getConsoleManager().addConsoles(new IConsole[]{console});
    }

    public void remove(IScriptConsole console) {
        this.getConsoleManager().removeConsoles(new IConsole[]{console});
    }

    protected IScriptConsoleFactory findScriptConsoleFactory(String natureId) throws CoreException {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.dltk.console.ui.scriptConsole");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] ce = ext.getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                if (natureId.equals(ce[j].getAttribute("natureID"))) {
                    Object obj = ce[j].createExecutableExtension("class");
                    if (obj instanceof IScriptConsoleFactory) {
                        return (IScriptConsoleFactory)obj;
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(final ILaunch launch) {
        block10: {
            if (!"run".equals(launch.getLaunchMode())) {
                return;
            }
            try {
                final ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                if (configuration == null) {
                    return;
                }
                boolean useDltk = configuration.getAttribute("use_dltk_interactive_console", false);
                if (!useDltk) {
                    return;
                }
                ScriptConsole console = this.getConsole(launch);
                if (console != null) {
                    IProcess[] processes = launch.getProcesses();
                    int i = 0;
                    while (i < processes.length) {
                        IProcess process = processes[i];
                        if (process instanceof IScriptProcess) {
                            console.connect((IScriptProcess)process);
                        }
                        ++i;
                    }
                    return;
                }
                final String natureId = configuration.getAttribute("nature", null);
                if (natureId == null) {
                    return;
                }
                final String consoleId = configuration.getAttribute("console_id", null);
                final IScriptConsoleFactory factory = this.findScriptConsoleFactory(natureId);
                if (factory == null) {
                    return;
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        IScriptInterpreter interpreter = ScriptInterpreterManager.getInstance().createInterpreter(natureId);
                        ScriptConsoleServer.getInstance().register(consoleId, (ConsoleRequest)interpreter);
                        factory.openConsole(interpreter, configuration.getName(), launch);
                    }
                });
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block10;
                e.printStackTrace();
            }
        }
    }

    private ScriptConsole getConsole(ILaunch launch) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            ScriptConsole sc;
            ILaunch consoleLaunch;
            IConsole console = consoles[i];
            if (console instanceof ScriptConsole && (consoleLaunch = (sc = (ScriptConsole)console).getLaunch()) != null && consoleLaunch.equals(launch)) {
                return sc;
            }
            ++i;
        }
        return null;
    }

    public void launchRemoved(ILaunch launch) {
        ScriptConsole console = this.getConsole(launch);
        if (console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{console});
        }
    }
}

