/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.internal.core.util.Util;

public class ProblemCollector
extends AbstractProblemReporter
implements ITaskReporter {
    protected final List<IProblem> problems = new ArrayList<IProblem>();

    public void reset() {
        this.problems.clear();
    }

    @Override
    public void reportProblem(IProblem problem) {
        if (!this.problems.contains(problem)) {
            this.problems.add(problem);
        }
    }

    @Override
    public void reportTask(String message, int lineNumber, int priority, int charStart, int charEnd) {
        this.reportProblem(new TaskInfo(message, lineNumber, priority, charStart, charEnd));
    }

    public boolean isEmpty() {
        return this.problems.isEmpty();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ITaskReporter.class.equals(adapter) || IProblemReporter.class.equals(adapter)) {
            return (T)this;
        }
        return super.getAdapter(adapter);
    }

    public boolean hasErrors() {
        if (!this.problems.isEmpty()) {
            for (IProblem problem : this.problems) {
                if (!problem.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.problems.toString();
    }

    public void copyTo(IProblemReporter destination) {
        for (IProblem problem : this.problems) {
            destination.reportProblem(problem);
        }
    }

    public List<IProblem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public List<IProblem> getErrors() {
        ArrayList<IProblem> result = new ArrayList<IProblem>();
        for (IProblem problem : this.problems) {
            if (!problem.isError()) continue;
            result.add(problem);
        }
        return result;
    }

    public void createMarkers(IResource resource, IProblemFactory problemFactory) throws CoreException {
        this.createMarkers(resource, problemFactory, IProblemSeverityTranslator.IDENTITY);
    }

    public void createMarkers(IResource resource, IProblemFactory problemFactory, IProblemSeverityTranslator translator) throws CoreException {
        for (IProblem problem : this.problems) {
            String[] arguments;
            ProblemSeverity severity = problem.getSeverity();
            if (!problem.isTask() && ((severity = translator.getSeverity(problem.getID(), severity)) == null || severity == ProblemSeverity.IGNORE)) continue;
            IMarker m = problemFactory.createMarker(resource, problem);
            if (problem.getSourceLineNumber() >= 0) {
                m.setAttribute("lineNumber", problem.getSourceLineNumber() + 1);
            }
            m.setAttribute("message", (Object)problem.getMessage());
            if (problem.getSourceStart() >= 0) {
                m.setAttribute("charStart", problem.getSourceStart());
            }
            if (problem.getSourceEnd() >= 0) {
                m.setAttribute("charEnd", problem.getSourceEnd());
            }
            if (!problem.isTask()) {
                m.setAttribute("severity", severity.value);
            } else {
                m.setAttribute("userEditable", (Object)Boolean.FALSE);
                if (problem instanceof TaskInfo) {
                    m.setAttribute("priority", ((TaskInfo)problem).getPriority());
                }
            }
            if (problem.getID() != null) {
                m.setAttribute("id", (Object)DefaultProblemIdentifier.encode(problem.getID()));
            }
            if ((arguments = problem.getArguments()) == null || arguments.length == 0) continue;
            m.setAttribute("arguments", (Object)Util.getProblemArgumentsForMarker(arguments));
        }
    }

    protected static class TaskInfo
    extends CategorizedProblem {
        private final String message;
        private final int charStart;
        private final int lineNumber;
        private final int charEnd;
        private final int priority;

        public TaskInfo(String message, int lineNumber, int priority, int charStart, int charEnd) {
            this.message = message;
            this.lineNumber = lineNumber;
            this.priority = priority;
            this.charEnd = charEnd;
            this.charStart = charStart;
        }

        @Override
        public int getCategoryID() {
            return 0;
        }

        @Override
        public boolean isTask() {
            return true;
        }

        @Override
        public String getMarkerType() {
            return "org.eclipse.dltk.core.task";
        }

        @Override
        public String[] getArguments() {
            return null;
        }

        @Override
        public IProblemIdentifier getID() {
            return IProblem.Task;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getOriginatingFileName() {
            return null;
        }

        @Override
        public int getSourceEnd() {
            return this.charEnd;
        }

        @Override
        public int getSourceLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getSourceStart() {
            return this.charStart;
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public void setSeverity(ProblemSeverity severity) {
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public boolean isWarning() {
            return false;
        }

        @Override
        public void setSourceEnd(int sourceEnd) {
        }

        @Override
        public void setSourceLineNumber(int lineNumber) {
        }

        @Override
        public void setSourceStart(int sourceStart) {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Task");
            sb.append(' ');
            sb.append(this.lineNumber);
            sb.append('[');
            sb.append(this.charStart);
            sb.append("..");
            sb.append(this.charEnd);
            sb.append(']');
            sb.append(':');
            if (this.message != null) {
                sb.append(this.message);
            }
            return sb.toString();
        }
    }
}

