/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ModelElementTransfer
extends ByteArrayTransfer {
    private static final ModelElementTransfer fInstance = new ModelElementTransfer();
    private static final String TYPE_NAME = "model-element-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)fInstance)).hashCode();
    private static final int TYPEID = ModelElementTransfer.registerType((String)TYPE_NAME);

    private ModelElementTransfer() {
    }

    public static ModelElementTransfer getInstance() {
        return fInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IModelElement[])) {
            return;
        }
        IModelElement[] modelElements = (IModelElement[])data;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    try (DataOutputStream dataOut = new DataOutputStream(out);){
                        dataOut.writeInt(modelElements.length);
                        int i = 0;
                        while (i < modelElements.length) {
                            ModelElementTransfer.writeScriptElement(dataOut, modelElements[i]);
                            ++i;
                        }
                        byte[] bytes = out.toByteArray();
                        super.javaToNative((Object)bytes, transferData);
                    }
                    if (out == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IModelElement[] results = new IModelElement[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readScriptElement(in);
                ++i;
            }
            return results;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IModelElement readScriptElement(DataInputStream dataIn) throws IOException {
        String handleIdentifier = dataIn.readUTF();
        return DLTKCore.create((String)handleIdentifier);
    }

    private static void writeScriptElement(DataOutputStream dataOut, IModelElement element) throws IOException {
        dataOut.writeUTF(element.getHandleIdentifier());
    }
}

