/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.FindReferencesAction;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class FindReferencesInHierarchyAction
extends FindReferencesAction {
    public FindReferencesInHierarchyAction(IDLTKLanguageToolkit toolkit, IWorkbenchSite site) {
        super(toolkit, site);
    }

    public FindReferencesInHierarchyAction(IDLTKLanguageToolkit toolkit, ScriptEditor editor) {
        super(toolkit, editor);
    }

    public FindReferencesInHierarchyAction(IDLTKLanguageToolkit toolkit, AbstractDecoratedTextEditor editor) {
        super(toolkit, editor);
    }

    @Override
    Class<?>[] getValidTypes() {
        return new Class[]{ISourceModule.class, IType.class, IMethod.class, IField.class};
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindHierarchyReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindHierarchyReferencesAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_REF);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add helkp support here...");
        }
    }

    @Override
    QuerySpecification createQuery(IModelElement element) throws ModelException {
        IType type = this.getType(element);
        if (type == null) {
            return super.createQuery(element);
        }
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        IDLTKSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        String description = factory.getHierarchyScopeDescription(type);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

