/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TimeTriggeredProgressMonitorDialog
extends ProgressMonitorDialog {
    private int longOperationTime;
    private long triggerTime = -1L;
    private boolean dialogOpened = false;
    private IProgressMonitor wrapperedMonitor;

    public TimeTriggeredProgressMonitorDialog(Shell parent, int longOperationTime) {
        super(parent);
        this.setOpenOnRun(false);
        this.longOperationTime = longOperationTime;
    }

    public void createWrapperedMonitor() {
        this.wrapperedMonitor = new IProgressMonitor(){
            IProgressMonitor superMonitor;
            {
                this.superMonitor = TimeTriggeredProgressMonitorDialog.super.getProgressMonitor();
            }

            public void beginTask(String name, int totalWork) {
                this.superMonitor.beginTask(name, totalWork);
                this.checkTicking();
            }

            private void checkTicking() {
                if (TimeTriggeredProgressMonitorDialog.this.triggerTime < 0L) {
                    TimeTriggeredProgressMonitorDialog.this.triggerTime = System.currentTimeMillis() + (long)TimeTriggeredProgressMonitorDialog.this.longOperationTime;
                }
                if (!TimeTriggeredProgressMonitorDialog.this.dialogOpened && System.currentTimeMillis() > TimeTriggeredProgressMonitorDialog.this.triggerTime) {
                    TimeTriggeredProgressMonitorDialog.this.open();
                    TimeTriggeredProgressMonitorDialog.this.dialogOpened = true;
                }
            }

            public void done() {
                this.superMonitor.done();
                this.checkTicking();
            }

            public void internalWorked(double work) {
                this.superMonitor.internalWorked(work);
                this.checkTicking();
            }

            public boolean isCanceled() {
                return this.superMonitor.isCanceled();
            }

            public void setCanceled(boolean value) {
                this.superMonitor.setCanceled(value);
            }

            public void setTaskName(String name) {
                this.superMonitor.setTaskName(name);
                this.checkTicking();
            }

            public void subTask(String name) {
                this.superMonitor.subTask(name);
                this.checkTicking();
            }

            public void worked(int work) {
                this.superMonitor.worked(work);
                this.checkTicking();
            }
        };
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.wrapperedMonitor == null) {
            this.createWrapperedMonitor();
        }
        return this.wrapperedMonitor;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        InvocationTargetException[] invokes = new InvocationTargetException[1];
        InterruptedException[] interrupt = new InterruptedException[1];
        Runnable dialogWaitRunnable = () -> {
            try {
                TimeTriggeredProgressMonitorDialog.super.run(fork, cancelable, runnable);
            }
            catch (InvocationTargetException e1) {
                invocationTargetExceptionArray[0] = e1;
            }
            catch (InterruptedException e2) {
                interruptedExceptionArray[0] = e2;
            }
        };
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)dialogWaitRunnable);
        if (invokes[0] != null) {
            throw invokes[0];
        }
        if (interrupt[0] != null) {
            throw interrupt[0];
        }
    }
}

