/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.utils.NatureExtensionManager;
import org.eclipse.dltk.validators.core.IValidatorType;

public class ValidatorManager
extends NatureExtensionManager {
    public static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.validators.core.validator";
    private static ValidatorManager instance = null;
    private static Map<String, IValidatorType> idToValidatorType = null;
    private static final IValidatorType[] NO_VALIDATORS = new IValidatorType[0];

    private ValidatorManager() {
        super(LANGUAGE_EXTPOINT, IValidatorType.class, "#");
    }

    private static synchronized ValidatorManager getInstance() {
        if (instance == null) {
            instance = new ValidatorManager();
        }
        return instance;
    }

    public static IValidatorType getValidatorTypeFromID(String id) {
        if (idToValidatorType == null) {
            idToValidatorType = new HashMap<String, IValidatorType>();
            try {
                IValidatorType[] allValidatorTypes = ValidatorManager.getAllValidatorTypes();
                int i = 0;
                while (i < allValidatorTypes.length) {
                    idToValidatorType.put(allValidatorTypes[i].getID(), allValidatorTypes[i]);
                    ++i;
                }
            }
            catch (CoreException e) {
                idToValidatorType = null;
                return null;
            }
        }
        return idToValidatorType.get(id);
    }

    protected Object[] createEmptyResult() {
        return NO_VALIDATORS;
    }

    public static IValidatorType[] getValidators(String natureId) throws CoreException {
        return (IValidatorType[])ValidatorManager.getInstance().getInstances(natureId);
    }

    public static IValidatorType[] getAllValidatorTypes() throws CoreException {
        return (IValidatorType[])ValidatorManager.getInstance().getAllInstances();
    }
}

