/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;

public class SourceElementRequestorDelegate
implements ISourceElementRequestor {
    private final ISourceElementRequestor target;

    public SourceElementRequestorDelegate(ISourceElementRequestor target) {
        this.target = target;
    }

    protected int translate(int offset) {
        return offset;
    }

    protected IElementRequestor.FieldInfo translate(IElementRequestor.FieldInfo info) {
        IElementRequestor.FieldInfo result = new IElementRequestor.FieldInfo();
        this.copy(info, result);
        result.type = info.type;
        return result;
    }

    private void copy(IElementRequestor.ElementInfo src, IElementRequestor.ElementInfo dest) {
        dest.name = src.name;
        dest.modifiers = src.modifiers;
        dest.declarationStart = this.translate(src.declarationStart);
        dest.nameSourceStart = this.translate(src.nameSourceStart);
        dest.nameSourceEnd = this.translate(src.nameSourceEnd);
    }

    protected IElementRequestor.MethodInfo translate(IElementRequestor.MethodInfo info) {
        IElementRequestor.MethodInfo result = new IElementRequestor.MethodInfo();
        this.copy(info, result);
        result.parameterNames = info.parameterNames;
        result.parameterInitializers = info.parameterInitializers;
        result.parameterTypes = info.parameterTypes;
        result.exceptionTypes = info.exceptionTypes;
        result.returnType = info.returnType;
        result.isConstructor = info.isConstructor;
        return result;
    }

    protected IElementRequestor.TypeInfo translate(IElementRequestor.TypeInfo info) {
        IElementRequestor.TypeInfo result = new IElementRequestor.TypeInfo();
        this.copy(info, result);
        result.superclasses = info.superclasses;
        return result;
    }

    protected IElementRequestor.ImportInfo translate(IElementRequestor.ImportInfo importInfo) {
        IElementRequestor.ImportInfo result = new IElementRequestor.ImportInfo();
        result.containerName = importInfo.containerName;
        result.name = importInfo.name;
        result.version = importInfo.version;
        result.sourceStart = this.translate(importInfo.sourceStart);
        result.sourceEnd = this.translate(importInfo.sourceEnd);
        return result;
    }

    @Override
    public void acceptFieldReference(String fieldName, int sourcePosition) {
        this.target.acceptFieldReference(fieldName, this.translate(sourcePosition));
    }

    @Override
    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
        this.target.acceptImport(this.translate(importInfo));
    }

    @Override
    public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        this.target.acceptMethodReference(methodName, argCount, this.translate(sourcePosition), this.translate(sourceEndPosition));
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, String name) {
        this.target.acceptPackage(this.translate(declarationStart), this.translate(declarationEnd), name);
    }

    @Override
    public void acceptTypeReference(String typeName, int sourcePosition) {
        this.target.acceptTypeReference(typeName, this.translate(sourcePosition));
    }

    @Override
    public void enterField(IElementRequestor.FieldInfo info) {
        this.target.enterField(this.translate(info));
    }

    @Override
    public void enterMethod(IElementRequestor.MethodInfo info) {
        this.target.enterMethod(this.translate(info));
    }

    @Override
    public void enterModule() {
        this.target.enterModule();
    }

    @Override
    public void enterModuleRoot() {
        this.target.enterModuleRoot();
    }

    @Override
    public void enterType(IElementRequestor.TypeInfo info) {
        this.target.enterType(this.translate(info));
    }

    @Override
    public void exitField(int declarationEnd) {
        this.target.exitField(this.translate(declarationEnd));
    }

    @Override
    public void exitMethod(int declarationEnd) {
        this.target.exitMethod(this.translate(declarationEnd));
    }

    @Override
    public void exitModule(int declarationEnd) {
        this.target.exitModule(this.translate(declarationEnd));
    }

    @Override
    public void exitModuleRoot() {
        this.target.exitModuleRoot();
    }

    @Override
    public void exitType(int declarationEnd) {
        this.target.exitType(this.translate(declarationEnd));
    }

    @Override
    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo info) {
        return this.target.enterFieldCheckDuplicates(this.translate(info));
    }

    @Override
    public void enterMethodRemoveSame(IElementRequestor.MethodInfo info) {
        this.target.enterMethodRemoveSame(this.translate(info));
    }

    @Override
    public boolean enterTypeAppend(String fullName, String delimiter) {
        return this.target.enterTypeAppend(fullName, fullName);
    }

    @Override
    public void enterNamespace(String[] namespace) {
        this.target.enterNamespace(namespace);
    }

    @Override
    public void exitNamespace() {
        this.target.exitNamespace();
    }
}

