/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchEngineExtension;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.index.lucene.BitFlagsQuery;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.LuceneManager;
import org.eclipse.dltk.internal.core.index.lucene.SearchMatch;
import org.eclipse.dltk.internal.core.index.lucene.SearchMatchHandler;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;

public class LuceneSearchEngine
implements ISearchEngineExtension {
    public void search(int elementType, String qualifier, String elementName, int trueFlags, int falseFlags, int limit, ISearchEngine.SearchFor searchFor, ISearchEngine.MatchRule matchRule, IDLTKSearchScope scope, ISearchRequestor requestor, IProgressMonitor monitor) {
        this.search(elementType, qualifier, elementName, null, trueFlags, falseFlags, limit, searchFor, matchRule, scope, requestor, monitor);
    }

    public void search(int elementType, String qualifier, String elementName, String parent, int trueFlags, int falseFlags, int limit, ISearchEngine.SearchFor searchFor, ISearchEngine.MatchRule matchRule, IDLTKSearchScope scope, ISearchRequestor requestor, IProgressMonitor monitor) {
        boolean searchForDecls = searchFor == ISearchEngine.SearchFor.DECLARATIONS || searchFor == ISearchEngine.SearchFor.ALL_OCCURRENCES;
        boolean searchForRefs = searchFor == ISearchEngine.SearchFor.REFERENCES || searchFor == ISearchEngine.SearchFor.ALL_OCCURRENCES;
        LinkedList<SearchTask> tasks = new LinkedList<SearchTask>();
        List<String> containers = SearchScope.getContainers(scope);
        List<String> scripts = SearchScope.getScripts(scope);
        SearchMatchHandler searchMatchHandler = new SearchMatchHandler(scope, requestor);
        if (searchForRefs) {
            for (String container : containers) {
                tasks.add(new SearchTask(elementType, qualifier, elementName, parent, trueFlags, falseFlags, true, matchRule, scripts, container));
            }
            tasks.stream().map(ForkJoinTask::fork).forEach(t -> ((List)t.join()).stream().forEach(m -> searchMatchHandler.handle((SearchMatch)m, true)));
        }
        if (searchForDecls) {
            tasks.clear();
            for (String container : containers) {
                tasks.add(new SearchTask(elementType, qualifier, elementName, parent, trueFlags, falseFlags, false, matchRule, scripts, container));
            }
            tasks.stream().map(ForkJoinTask::fork).forEach(t -> ((List)t.join()).stream().forEach(m -> searchMatchHandler.handle((SearchMatch)m, false)));
        }
    }

    private Query createQuery(String elementName, String qualifier, String parent, int trueFlags, int falseFlags, boolean searchForRefs, ISearchEngine.MatchRule matchRule, List<String> scripts) {
        BooleanQuery query;
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        if (!scripts.isEmpty()) {
            BooleanQuery.Builder scriptQueryBuilder = new BooleanQuery.Builder();
            for (String script : scripts) {
                scriptQueryBuilder.add((Query)new TermQuery(new Term("path", script)), BooleanClause.Occur.FILTER);
            }
            queryBuilder.add((Query)scriptQueryBuilder.build(), BooleanClause.Occur.FILTER);
        }
        if (elementName != null && !elementName.isEmpty()) {
            String elementNameLC = elementName.toLowerCase();
            PrefixQuery nameQuery = null;
            Term nameCaseInsensitiveTerm = new Term("elementNameLC", elementNameLC);
            if (matchRule == ISearchEngine.MatchRule.PREFIX) {
                nameQuery = new PrefixQuery(nameCaseInsensitiveTerm);
            } else if (matchRule == ISearchEngine.MatchRule.EXACT) {
                nameQuery = new TermQuery(nameCaseInsensitiveTerm);
            } else if (matchRule == ISearchEngine.MatchRule.CAMEL_CASE) {
                nameQuery = new PrefixQuery(new Term("ccName", elementName));
            } else if (matchRule == ISearchEngine.MatchRule.PATTERN) {
                nameQuery = new WildcardQuery(nameCaseInsensitiveTerm);
            } else {
                throw new UnsupportedOperationException();
            }
            if (nameQuery != null) {
                queryBuilder.add((Query)nameQuery, BooleanClause.Occur.FILTER);
            }
        }
        if (qualifier != null && !qualifier.isEmpty()) {
            queryBuilder.add((Query)new TermQuery(new Term("qualifier", qualifier)), BooleanClause.Occur.FILTER);
        }
        if (parent != null && !parent.isEmpty()) {
            queryBuilder.add((Query)new TermQuery(new Term("parent", parent)), BooleanClause.Occur.FILTER);
        }
        if (trueFlags != 0 || falseFlags != 0) {
            queryBuilder.add((Query)new BitFlagsQuery(trueFlags, falseFlags), BooleanClause.Occur.FILTER);
        }
        return (query = queryBuilder.build()).clauses().isEmpty() ? null : query;
    }

    private static final class ResultsCollector
    implements Collector {
        private static final String[] NUMERIC_FIELDS = new String[]{"offsetNDV", "lengthNDV", "flagsNDV", "nameOffsetNDV", "nameLengthNDV"};
        private static final String[] BINARY_FIELDS = new String[]{"pathBDV", "elementNameBDV", "qualifierBDV", "parentBDV", "metadataBDV", "docBDV"};
        private Map<String, NumericDocValues> fDocNumericValues;
        private Map<String, BinaryDocValues> fDocBinaryValues;
        private String fContainer;
        private int fElementType;
        private List<SearchMatch> fResult = new LinkedList<SearchMatch>();

        public ResultsCollector(String container, int elementType) {
            this.fContainer = container;
            this.fElementType = elementType;
        }

        public List<SearchMatch> getfResult() {
            return this.fResult;
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            NumericDocValues docValues;
            String field;
            LeafReader reader = context.reader();
            this.fDocNumericValues = new HashMap<String, NumericDocValues>();
            String[] stringArray = NUMERIC_FIELDS;
            int n = NUMERIC_FIELDS.length;
            int n2 = 0;
            while (n2 < n) {
                field = stringArray[n2];
                docValues = reader.getNumericDocValues(field);
                if (docValues != null) {
                    this.fDocNumericValues.put(field, docValues);
                }
                ++n2;
            }
            this.fDocBinaryValues = new HashMap<String, BinaryDocValues>();
            stringArray = BINARY_FIELDS;
            n = BINARY_FIELDS.length;
            n2 = 0;
            while (n2 < n) {
                field = stringArray[n2];
                docValues = reader.getBinaryDocValues(field);
                if (docValues != null) {
                    this.fDocBinaryValues.put(field, (BinaryDocValues)docValues);
                }
                ++n2;
            }
            return new LeafCollector(){

                public void setScorer(Scorable scorable) throws IOException {
                }

                public void collect(int docId) throws IOException {
                    this.addResult(docId);
                }
            };
        }

        private void addResult(int docId) {
            this.fResult.add(new SearchMatch(this.fContainer, this.fElementType, this.getNumericValue("offsetNDV", docId), this.getNumericValue("lengthNDV", docId), this.getNumericValue("nameOffsetNDV", docId), this.getNumericValue("nameLengthNDV", docId), this.getNumericValue("flagsNDV", docId), this.getStringValue("elementNameBDV", docId), this.getStringValue("pathBDV", docId), this.getStringValue("parentBDV", docId), this.getStringValue("qualifierBDV", docId), this.getStringValue("docBDV", docId), this.getStringValue("metadataBDV", docId)));
        }

        private long getNumericValue(String field, int docId) {
            NumericDocValues docValues = this.fDocNumericValues.get(field);
            if (docValues != null) {
                block4: {
                    docValues.advanceExact(docId);
                    if (docValues.advanceExact(docId)) break block4;
                    return 0L;
                }
                try {
                    return docValues.longValue();
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
            return 0L;
        }

        private String getStringValue(String field, int docId) {
            BinaryDocValues docValues = this.fDocBinaryValues.get(field);
            if (docValues != null) {
                block5: {
                    if (docValues.advanceExact(docId)) break block5;
                    return null;
                }
                try {
                    BytesRef bytesRef = docValues.binaryValue();
                    if (bytesRef.length > 0) {
                        return bytesRef.utf8ToString();
                    }
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
            return null;
        }
    }

    private static final class SearchScope {
        private SearchScope() {
        }

        static List<String> getContainers(IDLTKSearchScope scope) {
            ArrayList<String> containers = new ArrayList<String>();
            IPath[] iPathArray = scope.enclosingProjectsAndZips();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                containers.add(path.toString());
                ++n2;
            }
            return containers;
        }

        static List<String> getScripts(IDLTKSearchScope scope) {
            ArrayList<String> scripts = new ArrayList<String>();
            if (scope instanceof DLTKSearchScope) {
                String[] relativePaths = ((DLTKSearchScope)scope).getRelativePaths();
                String[] fileExtensions = ScriptModelUtil.getFileExtensions((IDLTKLanguageToolkit)scope.getLanguageToolkit());
                String[] stringArray = relativePaths;
                int n = relativePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String relativePath = stringArray[n2];
                    if (relativePath.length() > 0) {
                        if (fileExtensions != null) {
                            boolean isScriptFile = false;
                            String[] stringArray2 = fileExtensions;
                            int n3 = fileExtensions.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String ext = stringArray2[n4];
                                if (relativePath.endsWith("." + ext)) {
                                    isScriptFile = true;
                                    break;
                                }
                                ++n4;
                            }
                            if (!isScriptFile) break;
                        }
                        scripts.add(relativePath);
                    }
                    ++n2;
                }
            }
            return scripts;
        }
    }

    private class SearchTask
    extends RecursiveTask<List<SearchMatch>> {
        int elementType;
        String qualifier;
        String elementName;
        String parent;
        int trueFlags;
        int falseFlags;
        boolean searchForRefs;
        ISearchEngine.MatchRule matchRule;
        List<String> scripts;
        String container;

        private SearchTask(int elementType, String qualifier, String elementName, String parent, int trueFlags, int falseFlags, boolean searchForRefs, ISearchEngine.MatchRule matchRule, List<String> scripts, String container) {
            this.elementType = elementType;
            this.qualifier = qualifier;
            this.elementName = elementName;
            this.parent = parent;
            this.trueFlags = trueFlags;
            this.falseFlags = falseFlags;
            this.searchForRefs = searchForRefs;
            this.matchRule = matchRule;
            this.scripts = scripts;
            this.container = container;
        }

        @Override
        protected List<SearchMatch> compute() {
            SearcherManager searcherManager = LuceneManager.INSTANCE.findIndexSearcher(this.container, this.searchForRefs ? IndexType.REFERENCES : IndexType.DECLARATIONS, this.elementType);
            if (searcherManager == null) {
                return Collections.emptyList();
            }
            IndexSearcher indexSearcher = null;
            try {
                indexSearcher = (IndexSearcher)searcherManager.acquire();
                Query query = LuceneSearchEngine.this.createQuery(this.elementName, this.qualifier, this.parent, this.trueFlags, this.falseFlags, this.searchForRefs, this.matchRule, this.scripts);
                ResultsCollector collector = new ResultsCollector(this.container, this.elementType);
                if (query != null) {
                    indexSearcher.search(query, (Collector)collector);
                } else {
                    indexSearcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
                }
                List<SearchMatch> list = collector.getfResult();
                return list;
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            finally {
                if (indexSearcher != null) {
                    try {
                        searcherManager.release((Object)indexSearcher);
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
            }
            return Collections.emptyList();
        }
    }
}

