/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.eclipse.dltk.core.index2.IIndexingRequestor;

public enum DocumentFactory {
    INSTANCE;

    private String EMPTY = new String();
    private Document timestamp = new Document();
    private StringField timestampPath;
    private NumericDocValuesField timestampValue;
    private Document reference = new Document();
    private StringField referenceFPath;
    private StringField referenceFQualifier;
    private StringField referenceFElementNameLC;
    private NumericDocValuesField referenceNDVOffset;
    private NumericDocValuesField referenceNDVLength;
    private BinaryDocValuesField referenceBPath;
    private BinaryDocValuesField referenceBElementName;
    private BinaryDocValuesField referenceBQualifier;
    private BinaryDocValuesField referenceBMetadata;
    private Document declaration = new Document();
    private StringField declarationFPath;
    private StringField declarationFQualifier;
    private StringField declarationFParent;
    private StringField declarationFElementNameLC;
    private StringField declarationFElementNameCC;
    private NumericDocValuesField declarationNDVOffset;
    private NumericDocValuesField declarationNDVLength;
    private NumericDocValuesField declarationNDVNameOffset;
    private NumericDocValuesField declarationNDVNameLength;
    private NumericDocValuesField declarationNDVFlags;
    private BinaryDocValuesField declarationBPath;
    private BinaryDocValuesField declarationBElementName;
    private BinaryDocValuesField declarationBQualifier;
    private BinaryDocValuesField declarationBMetadata;
    private BinaryDocValuesField declarationBParent;
    private BinaryDocValuesField declarationBDoc;

    private DocumentFactory() {
        this.timestampPath = this.addStringEntry(this.timestamp, "path", true);
        this.timestampValue = this.addLongEntry(this.timestamp, "timestampNDV");
        this.referenceFPath = this.addStringEntry(this.reference, "path", false);
        this.referenceFQualifier = this.addStringEntry(this.reference, "qualifier", false);
        this.referenceFElementNameLC = this.addStringEntry(this.reference, "elementNameLC", false);
        this.referenceNDVOffset = this.addLongEntry(this.reference, "offsetNDV");
        this.referenceNDVLength = this.addLongEntry(this.reference, "lengthNDV");
        this.referenceBPath = this.addBinaryEntry(this.reference, "pathBDV");
        this.referenceBElementName = this.addBinaryEntry(this.reference, "elementNameBDV");
        this.referenceBQualifier = this.addBinaryEntry(this.reference, "qualifierBDV");
        this.referenceBMetadata = this.addBinaryEntry(this.reference, "metadataBDV");
        this.declarationFPath = this.addStringEntry(this.declaration, "path", false);
        this.declarationFParent = this.addStringEntry(this.declaration, "parent", false);
        this.declarationFQualifier = this.addStringEntry(this.declaration, "qualifier", false);
        this.declarationFElementNameLC = this.addStringEntry(this.declaration, "elementNameLC", false);
        this.declarationFElementNameCC = this.addStringEntry(this.declaration, "ccName", false);
        this.declarationNDVOffset = this.addLongEntry(this.declaration, "offsetNDV");
        this.declarationNDVLength = this.addLongEntry(this.declaration, "lengthNDV");
        this.declarationNDVNameOffset = this.addLongEntry(this.declaration, "nameOffsetNDV");
        this.declarationNDVNameLength = this.addLongEntry(this.declaration, "nameLengthNDV");
        this.declarationNDVFlags = this.addLongEntry(this.declaration, "flagsNDV");
        this.declarationBPath = this.addBinaryEntry(this.declaration, "pathBDV");
        this.declarationBElementName = this.addBinaryEntry(this.declaration, "elementNameBDV");
        this.declarationBParent = this.addBinaryEntry(this.declaration, "parentBDV");
        this.declarationBQualifier = this.addBinaryEntry(this.declaration, "qualifierBDV");
        this.declarationBMetadata = this.addBinaryEntry(this.declaration, "metadataBDV");
        this.declarationBDoc = this.addBinaryEntry(this.declaration, "docBDV");
    }

    public Document createForReference(String source, IIndexingRequestor.ReferenceInfo info) {
        this.referenceFPath.setStringValue(source);
        this.referenceFQualifier.setStringValue(info.qualifier != null ? info.qualifier : this.EMPTY);
        this.referenceFElementNameLC.setStringValue(info.elementName.toLowerCase());
        this.referenceNDVOffset.setLongValue((long)info.offset);
        this.referenceNDVLength.setLongValue((long)info.length);
        this.referenceBPath.setBytesValue(source.getBytes());
        this.referenceBElementName.setBytesValue(info.elementName.getBytes());
        this.referenceBQualifier.setBytesValue(info.qualifier == null ? BytesRef.EMPTY_BYTES : info.qualifier.getBytes());
        this.referenceBMetadata.setBytesValue(info.metadata == null ? BytesRef.EMPTY_BYTES : info.metadata.getBytes());
        return this.reference;
    }

    public Document createForDeclaration(String source, IIndexingRequestor.DeclarationInfo info) {
        this.declarationFPath.setStringValue(source);
        this.declarationFParent.setStringValue(info.parent != null ? info.parent : this.EMPTY);
        this.declarationFQualifier.setStringValue(info.qualifier != null ? info.qualifier : this.EMPTY);
        this.declarationFElementNameLC.setStringValue(info.elementName.toLowerCase());
        this.declarationFElementNameCC.setStringValue(this.ccValue(info.elementName));
        this.declarationNDVOffset.setLongValue((long)info.offset);
        this.declarationNDVLength.setLongValue((long)info.length);
        this.declarationNDVNameOffset.setLongValue((long)info.nameOffset);
        this.declarationNDVNameLength.setLongValue((long)info.nameLength);
        this.declarationNDVFlags.setLongValue((long)info.flags);
        this.declarationBPath.setBytesValue(source.getBytes());
        this.declarationBElementName.setBytesValue(info.elementName != null ? info.elementName.getBytes() : BytesRef.EMPTY_BYTES);
        this.declarationBParent.setBytesValue(info.parent != null ? info.parent.getBytes() : BytesRef.EMPTY_BYTES);
        this.declarationBQualifier.setBytesValue(info.qualifier != null ? info.qualifier.getBytes() : BytesRef.EMPTY_BYTES);
        this.declarationBMetadata.setBytesValue(info.metadata != null ? info.metadata.getBytes() : BytesRef.EMPTY_BYTES);
        this.declarationBDoc.setBytesValue(info.doc != null ? info.doc.getBytes() : BytesRef.EMPTY_BYTES);
        return this.declaration;
    }

    public Document createForTimestamp(String source, long timestamp) {
        this.timestampValue.setLongValue(timestamp);
        this.timestampPath.setStringValue(source);
        return this.timestamp;
    }

    private NumericDocValuesField addLongEntry(Document doc, String category) {
        NumericDocValuesField f = new NumericDocValuesField(category, 0L);
        doc.add((IndexableField)f);
        return f;
    }

    private StringField addStringEntry(Document doc, String category, boolean store) {
        StringField f = new StringField(category, this.EMPTY, store ? Field.Store.YES : Field.Store.NO);
        doc.add((IndexableField)f);
        return f;
    }

    private String ccValue(String value) {
        StringBuilder camelCaseNameBuf = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (Character.isUpperCase(ch)) {
                camelCaseNameBuf.append(ch);
            } else if (i == 0) break;
            ++i;
        }
        return camelCaseNameBuf.toString();
    }

    private BinaryDocValuesField addBinaryEntry(Document doc, String category) {
        BinaryDocValuesField f = new BinaryDocValuesField(category, new BytesRef());
        doc.add((IndexableField)f);
        return f;
    }
}

