/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.processors;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.itcl.internal.core.classes.IncrTclClassesManager;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclBodyDeclaration;
import org.eclipse.dltk.itcl.internal.core.parser.processors.IncrTclUtils;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclVisibilityUtils;

public class IncrTclBodyCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        if (statement == null || statement.getCount() == 0) {
            return null;
        }
        if (statement.getCount() < 4) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent(parent, (ASTNode)statement);
            return statement;
        }
        Expression procName = statement.getAt(1);
        String sName = IncrTclUtils.extractMethodName(procName);
        if (sName == null || sName.length() == 0) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent(parent, (ASTNode)statement);
            return statement;
        }
        Expression procArguments = statement.getAt(2);
        Expression procCode = statement.getAt(3);
        List arguments = IncrTclUtils.extractMethodArguments(procArguments);
        IncrTclBodyDeclaration method = new IncrTclBodyDeclaration(statement.sourceStart(), statement.sourceEnd());
        int index = sName.lastIndexOf("::");
        if (index == -1) {
            this.report(parser, "Wrong Class name", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            return statement;
        }
        String className = sName.substring(0, index);
        String methodName = sName.substring(index + 2);
        method.setName(methodName);
        method.setNameStart(procName.sourceStart());
        method.setNameEnd(procName.sourceEnd());
        method.acceptArguments(arguments);
        method.setKind(1);
        IncrTclUtils.parseBlockAdd(parser, procCode, (MethodDeclaration)method);
        if (TclVisibilityUtils.isPrivate((String)sName)) {
            method.setModifier(0x400010);
        } else {
            method.setModifier(0x400040);
        }
        ModuleDeclaration module = this.getModuleDeclaration();
        TypeDeclaration possiblyType = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)parent, (String)className, (boolean)false);
        if (possiblyType != null) {
            MethodDeclaration[] methods = possiblyType.getMethods();
            boolean found = false;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equals(methodName)) {
                    method.setModifiers(methods[i].getModifiers());
                    method.setDeclaringType((ASTNode)possiblyType);
                    method.setDeclaringTypeName(TclParseUtil.getElementFQN((ASTNode)possiblyType, (String)"::", (ModuleDeclaration)module));
                    this.addToParent(parent, (ASTNode)method);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.addToParent(parent, (ASTNode)method);
                this.report(parser, "Function " + method.getName() + " is not defined in class " + possiblyType.getName(), statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Warning);
            }
        } else {
            if (!IncrTclClassesManager.getDefault().isClass(className)) {
                this.report(parser, "Body declaration for unknown class", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            }
            this.addToParent(parent, (ASTNode)method);
        }
        return method;
    }
}

