/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.issue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubTaskDataHandler;
import org.eclipse.mylyn.internal.github.core.issue.IssueAttribute;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.core.issue.IssueOperation;
import org.eclipse.mylyn.internal.github.core.issue.Messages;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class IssueTaskDataHandler
extends GitHubTaskDataHandler {
    private static final String DATA_VERSION = "1";
    private static final String MILESTONE_NONE_KEY = "0";
    private final IssueConnector connector;

    public IssueTaskDataHandler(IssueConnector connector) {
        this.connector = connector;
    }

    public TaskData createTaskData(TaskRepository repository, IProgressMonitor monitor, String user, String project, Issue issue) {
        String key = Integer.toString(issue.getNumber());
        TaskData data = new TaskData(this.getAttributeMapper(repository), "github", repository.getRepositoryUrl(), key);
        data.setVersion(DATA_VERSION);
        this.createOperations(data, issue);
        this.createAttribute(data, IssueAttribute.KEY.getMetadata(), key);
        this.createAttribute(data, IssueAttribute.TITLE.getMetadata(), issue.getTitle());
        this.createAttribute(data, IssueAttribute.BODY.getMetadata(), issue.getBody());
        this.createAttribute(data, IssueAttribute.STATUS.getMetadata(), issue.getState());
        this.createAttribute(data, IssueAttribute.CREATION_DATE.getMetadata(), issue.getCreatedAt());
        this.createAttribute(data, IssueAttribute.MODIFICATION_DATE.getMetadata(), issue.getUpdatedAt());
        this.createAttribute(data, IssueAttribute.CLOSED_DATE.getMetadata(), issue.getClosedAt());
        User reporter = issue.getUser();
        this.createAttribute(data, IssueAttribute.REPORTER.getMetadata(), reporter, repository);
        String reporterGravatar = reporter != null ? reporter.getAvatarUrl() : null;
        this.createAttribute(data, IssueAttribute.REPORTER_GRAVATAR.getMetadata(), reporterGravatar);
        User assignee = issue.getAssignee();
        this.createAttribute(data, IssueAttribute.ASSIGNEE.getMetadata(), assignee, repository);
        String assigneeGravatar = assignee != null ? assignee.getAvatarUrl() : null;
        this.createAttribute(data, IssueAttribute.ASSIGNEE_GRAVATAR.getMetadata(), assigneeGravatar);
        this.createAttribute(data, IssueAttribute.COMMENT_NEW.getMetadata());
        this.createLabels(repository, data, issue);
        this.createMilestones(repository, data, issue);
        return data;
    }

    private void createMilestones(TaskRepository repository, TaskData data, Issue issue) {
        Milestone current = issue.getMilestone();
        String number = current != null ? Integer.toString(current.getNumber()) : MILESTONE_NONE_KEY;
        TaskAttribute milestoneAttribute = this.createAttribute(data, IssueAttribute.MILESTONE.getMetadata(), number);
        if (!this.connector.hasCachedMilestones(repository)) {
            try {
                this.connector.refreshMilestones(repository);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        List<Milestone> cachedMilestones = this.connector.getMilestones(repository);
        milestoneAttribute.putOption(MILESTONE_NONE_KEY, Messages.IssueAttribute_MilestoneNone);
        for (Milestone milestone : cachedMilestones) {
            milestoneAttribute.putOption(Integer.toString(milestone.getNumber()), milestone.getTitle());
        }
    }

    private void createLabels(TaskRepository repository, TaskData data, Issue issue) {
        TaskAttribute labels = this.createAttribute(data, IssueAttribute.LABELS, issue.getLabels());
        if (!this.connector.hasCachedLabels(repository)) {
            try {
                this.connector.refreshLabels(repository);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        List<Label> cachedLabels = this.connector.getLabels(repository);
        for (Label label : cachedLabels) {
            labels.putOption(label.getName(), label.getName());
        }
    }

    private void createOperations(TaskData data, Issue issue) {
        String state;
        this.createOperationAttribute(data);
        if (!data.isNew() && (state = issue.getState()) != null) {
            this.addOperation(data, issue, IssueOperation.LEAVE, true);
            if (state.equals("open")) {
                this.addOperation(data, issue, IssueOperation.CLOSE, false);
            } else if (state.equals("closed")) {
                this.addOperation(data, issue, IssueOperation.REOPEN, false);
            }
        }
    }

    private void addOperation(TaskData data, Issue issue, IssueOperation operation, boolean isDefault) {
        String id = operation.getId();
        String label = this.createOperationLabel(issue, operation);
        this.addOperation(data, id, label, isDefault);
    }

    private String createOperationLabel(Issue issue, IssueOperation operation) {
        return operation == IssueOperation.LEAVE ? operation.getLabel() + issue.getState() : operation.getLabel();
    }

    public TaskData createTaskData(TaskRepository repository, IProgressMonitor monitor, String user, String project, Issue issue, List<Comment> comments) {
        TaskData taskData = this.createTaskData(repository, monitor, user, project, issue);
        taskData.setPartial(false);
        this.addComments(taskData.getRoot(), comments, repository);
        return taskData;
    }

    private Issue createIssue(TaskData taskData) {
        String milestoneValue;
        Issue issue = new Issue();
        if (!taskData.isNew()) {
            issue.setNumber(Integer.parseInt(taskData.getTaskId()));
        }
        issue.setBody(this.getAttributeValue(taskData, IssueAttribute.BODY.getMetadata()));
        issue.setTitle(this.getAttributeValue(taskData, IssueAttribute.TITLE.getMetadata()));
        String assigneeValue = this.getAttributeValue(taskData, IssueAttribute.ASSIGNEE.getMetadata());
        if (assigneeValue != null) {
            if (assigneeValue.trim().length() == 0) {
                assigneeValue = null;
            }
            User assignee = new User().setLogin(assigneeValue);
            issue.setAssignee(assignee);
        }
        if ((milestoneValue = this.getAttributeValue(taskData, IssueAttribute.MILESTONE.getMetadata())) != null) {
            Milestone milestone = new Milestone();
            if (milestoneValue.length() > 0) {
                milestone.setNumber(Integer.parseInt(milestoneValue));
            }
            issue.setMilestone(milestone);
        }
        return issue;
    }

    private TaskAttribute createAttribute(TaskData data, IssueAttribute attribute, List<Label> values) {
        TaskAttribute attr = this.createAttribute(data, attribute.getMetadata());
        if (values != null) {
            ArrayList<String> labels = new ArrayList<String>(values.size());
            for (Label label : values) {
                labels.add(label.getName());
            }
            data.getAttributeMapper().setValues(attr, labels);
        }
        return attr;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        data.setVersion(DATA_VERSION);
        IssueAttribute[] issueAttributeArray = IssueAttribute.values();
        int n = issueAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IssueAttribute attr = issueAttributeArray[n2];
            if (attr.getMetadata().isInitTask()) {
                this.createAttribute(data, attr.getMetadata(), (String)null);
            }
            ++n2;
        }
        Issue dummy = new Issue();
        this.createLabels(repository, data, dummy);
        this.createMilestones(repository, data, dummy);
        return true;
    }

    protected void updateLabels(String user, String repo, GitHubClient client, TaskRepository repository, TaskData data, Set<TaskAttribute> oldAttributes, Issue issue) {
        TaskAttribute labelsAttribute = data.getRoot().getAttribute(IssueAttribute.LABELS.getMetadata().getId());
        if (oldAttributes.contains(labelsAttribute) || data.isNew()) {
            LabelService labelService = new LabelService(client);
            if (!this.connector.hasCachedLabels(repository)) {
                try {
                    this.connector.refreshLabels(repository);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            List<Label> currentLabels = this.connector.getLabels(repository);
            LinkedList<Label> newLabels = new LinkedList<Label>();
            LinkedList<Label> labels = new LinkedList<Label>();
            for (String value : labelsAttribute.getValues()) {
                Label label = new Label().setName(value);
                if (!currentLabels.contains(label)) {
                    newLabels.add(label);
                }
                labels.add(label);
            }
            issue.setLabels(labels);
            for (Label label : newLabels) {
                try {
                    labelService.createLabel(user, repo, label);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!newLabels.isEmpty()) {
                try {
                    this.connector.refreshLabels(repository);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        String taskId = taskData.getTaskId();
        Issue issue = this.createIssue(taskData);
        RepositoryId repo = GitHub.getRepository(repository.getRepositoryUrl());
        try {
            GitHubClient client = IssueConnector.createClient(repository);
            boolean collaborator = this.isCollaborator(client, repo);
            if (collaborator) {
                this.updateLabels(repo.getOwner(), repo.getName(), client, repository, taskData, oldAttributes, issue);
            }
            IssueService service = new IssueService(client);
            if (taskData.isNew()) {
                issue.setState("open");
                issue = service.createIssue(repo.getOwner(), repo.getName(), issue);
                taskId = Integer.toString(issue.getNumber());
            } else {
                String comment = this.getAttributeValue(taskData, IssueAttribute.COMMENT_NEW.getMetadata());
                if (comment != null && comment.length() > 0) {
                    service.createComment(repo.getOwner(), repo.getName(), taskId, comment);
                }
                boolean reporter = this.attributeMatchesUser(client, IssueAttribute.REPORTER.getMetadata(), taskData);
                if (collaborator || reporter) {
                    TaskAttribute operationAttribute = taskData.getRoot().getAttribute("task.common.operation");
                    if (operationAttribute != null) {
                        IssueOperation operation = IssueOperation.fromId(operationAttribute.getValue());
                        if (operation == IssueOperation.REOPEN) {
                            issue.setState("open");
                        } else if (operation == IssueOperation.CLOSE) {
                            issue.setState("closed");
                        }
                    }
                    service.editIssue(repo.getOwner(), repo.getName(), issue);
                }
            }
            return new RepositoryResponse(taskData.isNew() ? RepositoryResponse.ResponseKind.TASK_CREATED : RepositoryResponse.ResponseKind.TASK_UPDATED, taskId);
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }
}

