/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.ui.editor.AbstractFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

public class PluginFoldingStructureProvider
extends AbstractFoldingStructureProvider {
    private final Map<Position, IDocumentElementNode> fPositionToElement = new HashMap<Position, IDocumentElementNode>();

    public PluginFoldingStructureProvider(PDESourcePage editor, IEditingModel model) {
        super(editor, model);
    }

    @Override
    public void addFoldingRegions(Set<Position> currentRegions, IEditingModel model) throws BadLocationException {
        IExtensions extensions = ((IPluginModelBase)model).getExtensions();
        IPluginExtension[] pluginExtensions = extensions.getExtensions();
        this.addFoldingRegions(currentRegions, pluginExtensions, model.getDocument());
    }

    private void addFoldingRegions(Set<Position> regions, IPluginExtension[] nodes, IDocument document) throws BadLocationException {
        IPluginExtension[] iPluginExtensionArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode[] children;
            int endLine;
            IPluginExtension node = iPluginExtensionArray[n2];
            IDocumentElementNode element = (IDocumentElementNode)node;
            int startLine = document.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = document.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = document.getLineOffset(startLine);
                int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((children = element.getChildNodes()) != null) {
                this.addFoldingRegions(regions, children, document);
            }
            ++n2;
        }
    }

    private void addFoldingRegions(Set<Position> regions, IDocumentElementNode[] nodes, IDocument document) throws BadLocationException {
        IDocumentElementNode[] iDocumentElementNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode[] children;
            int endLine;
            IDocumentElementNode node = iDocumentElementNodeArray[n2];
            int startLine = document.getLineOfOffset(node.getOffset());
            if (startLine < (endLine = document.getLineOfOffset(node.getOffset() + node.getLength()))) {
                int start = document.getLineOffset(startLine);
                int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, node);
            }
            if ((children = node.getChildNodes()) != null) {
                this.addFoldingRegions(regions, children, document);
            }
            ++n2;
        }
    }
}

