/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.RegPublishServiceInterfaceSimpleAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.transport.TransportException;

public class RegPublishServiceSimpleAction
extends PublishAction {
    public RegPublishServiceSimpleAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(1));
        this.propertyTable_.put("queryStyleServices", String.valueOf(0));
    }

    @Override
    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String busNodeIds = parser.getParameter("nodeId_Business");
        String wsdlURL = parser.getParameter("wsdlURL");
        String name = parser.getParameter("simpleServiceName");
        String description = parser.getParameter("simpleServiceDescription");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (busNodeIds != null) {
            Vector<ListElement> serviceBusiness = (Vector<ListElement>)formToolPI.getProperty("simpleServiceBusiness");
            if (serviceBusiness == null) {
                serviceBusiness = new Vector<ListElement>();
            } else {
                serviceBusiness.removeAllElements();
            }
            Vector serviceBusinessCopy = (Vector)formToolPI.getProperty("simpleServiceBusinessCopy");
            ListElement listElement = (ListElement)serviceBusinessCopy.elementAt(0);
            serviceBusiness.addElement(listElement);
            BusinessEntity be = (BusinessEntity)listElement.getObject();
            this.propertyTable_.put("simpleServiceBusiness", serviceBusiness);
            this.propertyTable_.put("simpleServiceServiceProvider", be);
            this.propertyTable_.put("uuidBusinessKey", be.getBusinessKey());
        } else {
            this.removeProperty("simpleServiceBusiness");
            this.removeProperty("simpleServiceServiceProvider");
            if (!this.subQueryInitiated_) {
                inputsValid = false;
                formToolPI.flagError("simpleServiceBusiness");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_BUSINESS"));
            }
        }
        if (wsdlURL != null) {
            this.propertyTable_.put("wsdlURL", wsdlURL);
            this.propertyTable_.put("simpleServiceWSDLURL", wsdlURL);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(wsdlURL)) {
            inputsValid = false;
            formToolPI.flagError("simpleServiceWSDLURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_WSDL_URL"));
        }
        if (name != null) {
            this.propertyTable_.put("simpleServiceName", name);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(name)) {
            inputsValid = false;
            formToolPI.flagError("simpleServiceName");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_NAME"));
        }
        if (description != null) {
            this.propertyTable_.put("simpleServiceDescription", description);
        }
        return inputsValid;
    }

    @Override
    public final boolean run() {
        String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
        String userId = (String)this.propertyTable_.get("advancedUserId");
        String password = (String)this.propertyTable_.get("advancedPassword");
        BusinessEntity be = (BusinessEntity)this.propertyTable_.get("simpleServiceServiceProvider");
        String businessKey = (String)this.propertyTable_.get("uuidBusinessKey");
        String wsdlURL = (String)this.propertyTable_.get("simpleServiceWSDLURL");
        String name = (String)this.propertyTable_.get("simpleServiceName");
        String description = (String)this.propertyTable_.get("simpleServiceDescription");
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        try {
            UDDIProxy proxy = regElement.getProxy();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            Uddi4jHelper uddi4jHelper = new Uddi4jHelper();
            Definition def = uddi4jHelper.getWSDLDefinition(wsdlURL);
            RegPublishServiceInterfaceSimpleAction regPublishSIAction = new RegPublishServiceInterfaceSimpleAction(this.controller_);
            int currentNodeId = this.getSelectedNavigatorNode().getNodeId();
            NodeManager nodeManager = this.regNode_.getNodeManager();
            Hashtable tModelsTable = new Hashtable();
            TModel[] tModels = null;
            if (uddi4jHelper.isMonolithicWSDL(def)) {
                tModels = new TModel[]{uddi4jHelper.newTModel(wsdlURL, def)};
            } else {
                String[] imports = uddi4jHelper.getImports(def, wsdlURL);
                tModels = new TModel[imports.length];
                int i = 0;
                while (i < tModels.length) {
                    tModels[i] = uddi4jHelper.newTModel(imports[i]);
                    ++i;
                }
            }
            if (tModels != null) {
                int i = 0;
                while (i < tModels.length) {
                    boolean inputsValid = regPublishSIAction.populatePropertyTable(uddi4jHelper.getWSDL(tModels[i]), tModels[i]);
                    if (inputsValid) {
                        regPublishSIAction.run();
                        Object savedTModel = regPublishSIAction.getPropertyTable().get("savedTModel");
                        if (savedTModel != null) {
                            tModelsTable.put(((TModel)savedTModel).getNameString(), savedTModel);
                        }
                        nodeManager.setSelectedNodeId(currentNodeId);
                    }
                    ++i;
                }
            }
            BusinessService bs = uddi4jHelper.newBusinessService(wsdlURL, def, tModelsTable);
            if (be != null) {
                bs.setBusinessKey(be.getBusinessKey());
            } else if (businessKey != null) {
                bs.setBusinessKey(businessKey);
            }
            bs.setDefaultName(new Name(name));
            bs.setDefaultDescriptionString(description);
            Vector<BusinessService> bsVector = new Vector<BusinessService>();
            bsVector.add(bs);
            regElement.handlePreInvocation(bs);
            bs = (BusinessService)proxy.save_service(regElement.getAuthInfoString(), bsVector).getBusinessServiceVector().get(0);
            this.addPublishedItemNode(bs, regElement);
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_PUBLISHED", bs.getDefaultNameString()));
            return true;
        }
        catch (WSDLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("WSDLException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                regElement.setDefaults();
            }
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

