/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class ContentTypeRelatedExtensionTracker<T>
implements ServiceTrackerCustomizer<T, LazyServiceSupplier<T>> {
    private final BundleContext bundleContext;
    private final ServiceTracker<T, LazyServiceSupplier<T>> serviceTracker;
    private Consumer<LazyServiceSupplier<T>> addAction;
    private Consumer<LazyServiceSupplier<T>> removeAction;
    private final Display display;

    ContentTypeRelatedExtensionTracker(BundleContext bundleContext, Class<T> serviceType, Display display) {
        this.bundleContext = bundleContext;
        this.display = display;
        this.serviceTracker = new ServiceTracker(bundleContext, serviceType, (ServiceTrackerCustomizer)this);
    }

    public void stopTracking() {
        this.serviceTracker.close();
    }

    public LazyServiceSupplier<T> addingService(ServiceReference<T> reference) {
        LazyServiceSupplier<T> supplier = new LazyServiceSupplier<T>(this.bundleContext, reference);
        if (this.addAction != null) {
            this.display.asyncExec(() -> this.addAction.accept(supplier));
        }
        return supplier;
    }

    public void modifiedService(ServiceReference<T> reference, LazyServiceSupplier<T> service) {
        service.update();
    }

    public void removedService(ServiceReference<T> reference, LazyServiceSupplier<T> service) {
        service.dispose();
        if (this.removeAction != null) {
            this.display.asyncExec(() -> this.removeAction.accept(service));
        }
    }

    public void onAdd(Consumer<LazyServiceSupplier<T>> action) {
        this.addAction = action;
    }

    public void onRemove(Consumer<LazyServiceSupplier<T>> action) {
        this.removeAction = action;
    }

    public void startTracking() {
        this.serviceTracker.open();
    }

    public Collection<LazyServiceSupplier<T>> getTracked() {
        return this.serviceTracker.getTracked().values();
    }

    public static final class LazyServiceSupplier<S>
    implements Supplier<S> {
        private final ServiceReference<S> reference;
        private final BundleContext bundleContext;
        private boolean disposed;
        private S serviceObject;
        private IContentType contentType;

        LazyServiceSupplier(BundleContext bundleContext, ServiceReference<S> reference) {
            this.reference = reference;
            this.bundleContext = bundleContext;
            this.update();
        }

        private String getProperty(String attribute) {
            return (String)this.reference.getProperty(attribute);
        }

        synchronized void update() {
            this.contentType = Platform.getContentTypeManager().getContentType(this.getProperty("contentType"));
        }

        public synchronized IContentType getContentType() {
            return this.contentType;
        }

        synchronized void dispose() {
            this.disposed = true;
            if (this.serviceObject != null) {
                this.bundleContext.ungetService(this.reference);
            }
        }

        @Override
        public synchronized S get() {
            if (!this.disposed && this.serviceObject == null) {
                this.serviceObject = this.bundleContext.getService(this.reference);
            }
            return this.serviceObject;
        }

        public synchronized boolean isPresent() {
            return this.serviceObject != null;
        }
    }
}

