"use strict";
// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.SidePanelToolbar = void 0;
const widgets_1 = require("@phosphor/widgets");
const widgets_2 = require("../widgets");
const event_1 = require("../../common/event");
class SidePanelToolbar extends widgets_2.BaseWidget {
    constructor(tabBarToolbarRegistry, tabBarToolbarFactory, side) {
        super();
        this.tabBarToolbarRegistry = tabBarToolbarRegistry;
        this.tabBarToolbarFactory = tabBarToolbarFactory;
        this.side = side;
        this.onContextMenuEmitter = new event_1.Emitter();
        this.onContextMenu = this.onContextMenuEmitter.event;
        this.toDispose.push(this.onContextMenuEmitter);
        this.init();
        this.tabBarToolbarRegistry.onDidChange(() => this.update());
    }
    onBeforeAttach(msg) {
        super.onBeforeAttach(msg);
        if (this.titleContainer) {
            this.addEventListener(this.titleContainer, 'contextmenu', e => this.onContextMenuEmitter.fire(e));
        }
    }
    onAfterAttach(msg) {
        if (this.toolbar) {
            if (this.toolbar.isAttached) {
                widgets_1.Widget.detach(this.toolbar);
            }
            widgets_1.Widget.attach(this.toolbar, this.node);
        }
        super.onAfterAttach(msg);
    }
    onBeforeDetach(msg) {
        if (this.titleContainer) {
            this.node.removeChild(this.titleContainer);
        }
        if (this.toolbar && this.toolbar.isAttached) {
            widgets_1.Widget.detach(this.toolbar);
        }
        super.onBeforeDetach(msg);
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.updateToolbar();
    }
    updateToolbar() {
        var _a, _b;
        if (!this.toolbar) {
            return;
        }
        const widget = (_b = (_a = this._toolbarTitle) === null || _a === void 0 ? void 0 : _a.owner) !== null && _b !== void 0 ? _b : undefined;
        this.toolbar.updateTarget(widget);
    }
    init() {
        this.titleContainer = document.createElement('div');
        this.titleContainer.classList.add('theia-sidepanel-title');
        this.titleContainer.classList.add('noWrapInfo');
        this.titleContainer.classList.add('noselect');
        this.node.appendChild(this.titleContainer);
        this.node.classList.add('theia-sidepanel-toolbar');
        this.node.classList.add(`theia-${this.side}-side-panel`);
        this.toolbar = this.tabBarToolbarFactory();
        this.update();
    }
    set toolbarTitle(title) {
        if (this.titleContainer && title) {
            this._toolbarTitle = title;
            this.titleContainer.innerText = this._toolbarTitle.label;
            this.titleContainer.title = this._toolbarTitle.caption || this._toolbarTitle.label;
            this.update();
        }
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
    showMoreContextMenu(anchor) {
        if (this.toolbar) {
            return this.toolbar.renderMoreContextMenu(anchor);
        }
        throw new Error(this.id + ' widget is not attached');
    }
}
exports.SidePanelToolbar = SidePanelToolbar;
//# sourceMappingURL=side-panel-toolbar.js.map